/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class AnputsFingersBlock
extends CropsBlock {
    private static final IntegerProperty ANPUTS_FINGERS_AGE = BlockStateProperties.field_208168_U;
    private static final VoxelShape[] SHAPE = new VoxelShape[]{VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.3125, (double)1.0), VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.6875, (double)1.0), VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0)};
    private final HashMap<UUID, Integer> lastTouchedTick = new HashMap();

    public AnputsFingersBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151670_w).func_200944_c().func_200942_a().func_226896_b_());
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPE[this.func_185527_x(state)];
    }

    @Nonnull
    protected IItemProvider func_199772_f() {
        return AtumItems.ANPUTS_FINGERS_SPORES;
    }

    @Nonnull
    public IntegerProperty func_185524_e() {
        return ANPUTS_FINGERS_AGE;
    }

    public int func_185526_g() {
        return 3;
    }

    protected boolean func_200014_a_(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return state.func_177230_c() == AtumBlocks.SAND;
    }

    public boolean func_196260_a(@Nonnull BlockState state, IWorldReader world, @Nonnull BlockPos pos) {
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return this.func_200014_a_(stateDown, (IBlockReader)world, pos.func_177977_b()) && world.func_226658_a_(LightType.SKY, pos) < 14;
    }

    public void func_225534_a_(@Nonnull BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        int age = this.func_185527_x(state);
        if (age < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (rand.nextInt(8) == 0 ? 1 : 0) != 0)) {
            BlockState newState = (BlockState)state.func_206870_a((Property)this.func_185524_e(), (Comparable)Integer.valueOf(age + 1));
            world.func_180501_a(pos, newState, 2);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_196262_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            MinecraftServer server = world.func_73046_m();
            Integer lastTouched = this.lastTouchedTick.get(player.func_110124_au());
            if (server != null) {
                if (lastTouched != null && server.func_71259_af() - lastTouched < 35) {
                    return;
                }
                if (player.func_71024_bL().func_75116_a() > 0) {
                    player.func_71024_bL().func_75122_a(-1, -0.1f);
                    this.lastTouchedTick.put(player.func_110124_au(), server.func_71259_af());
                }
            }
        }
    }

    public boolean func_176473_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{ANPUTS_FINGERS_AGE});
    }
}

