/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines.tileentity;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.blocks.base.tileentity.InventoryBaseTileEntity;
import com.teammetallurgy.atum.blocks.machines.GodforgeBlock;
import com.teammetallurgy.atum.init.AtumTileEntities;
import com.teammetallurgy.atum.inventory.container.block.GodforgeContainer;
import com.teammetallurgy.atum.items.GodshardItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class GodforgeTileEntity
extends InventoryBaseTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    private int burnTime;
    private int cookTime;
    private int cookTimeTotal;
    public final IIntArray godforgeData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return GodforgeTileEntity.this.burnTime;
                }
                case 1: {
                    return GodforgeTileEntity.this.cookTime;
                }
                case 2: {
                    return GodforgeTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    GodforgeTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    GodforgeTileEntity.this.cookTime = value;
                    break;
                }
                case 2: {
                    GodforgeTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public GodforgeTileEntity() {
        super(AtumTileEntities.GODFORGE, 3);
    }

    @Nonnull
    protected Container func_213906_a(int id, @Nonnull PlayerInventory playerInventory) {
        return new GodforgeContainer(id, playerInventory, this);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.burnTime = nbt.func_74762_e("BurnTime");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        return compound;
    }

    public void func_73660_a() {
        boolean isBurningCache = this.isBurning();
        boolean markDirty = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            God godCache = (God)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(GodforgeBlock.GOD));
            ItemStack fuel = (ItemStack)this.inventory.get(1);
            ItemStack input = (ItemStack)this.inventory.get(0);
            if (this.isBurning() || !fuel.func_190926_b() && !input.func_190926_b()) {
                if (this.canSmelt(input)) {
                    if (godCache != ((IArtifact)input.func_77973_b()).getGod()) {
                        markDirty = true;
                        this.setGodforgeState(input);
                    }
                    if (!this.isBurning()) {
                        this.burnTime = this.getBurnTime(fuel);
                        if (this.isBurning()) {
                            markDirty = true;
                            if (fuel.hasContainerItem()) {
                                this.inventory.set(1, (Object)fuel.getContainerItem());
                            } else if (!fuel.func_190926_b() && fuel.func_190926_b()) {
                                this.inventory.set(1, (Object)fuel.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(input)) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTime();
                        this.smelt(input);
                        markDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (isBurningCache != this.isBurning()) {
                markDirty = true;
                this.setGodforgeState(input);
            }
        }
        if (markDirty) {
            this.func_70296_d();
        }
    }

    public void setGodforgeState(@Nonnull ItemStack input) {
        if (this.field_145850_b != null) {
            GodforgeBlock.setLitGod(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.isBurning(), input.func_190926_b() ? God.ANPUT : ((IArtifact)input.func_77973_b()).getGod());
        }
    }

    protected boolean canSmelt(@Nonnull ItemStack input) {
        if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
            if (input.func_190926_b() || !(input.func_77973_b() instanceof IArtifact)) {
                return false;
            }
            ItemStack output = (ItemStack)this.inventory.get(2);
            IArtifact artifact = (IArtifact)input.func_77973_b();
            if (output.func_190926_b()) {
                return true;
            }
            if (!((GodshardItem)output.func_77973_b()).getGod().equals((Object)artifact.getGod())) {
                return false;
            }
            if (output.func_190916_E() + input.func_190916_E() <= this.func_70297_j_() && output.func_190916_E() + input.func_190916_E() <= output.func_77976_d()) {
                return true;
            }
            return output.func_190916_E() + input.func_190916_E() <= input.func_77976_d();
        }
        return false;
    }

    private void smelt(@Nonnull ItemStack input) {
        if (!input.func_190926_b() && this.canSmelt(input)) {
            ItemStack fuel = (ItemStack)this.inventory.get(0);
            ItemStack outputStack = new ItemStack((IItemProvider)GodshardItem.getGodshardFromGod(((IArtifact)input.func_77973_b()).getGod()), 4);
            ItemStack output = (ItemStack)this.inventory.get(2);
            if (output.func_190926_b()) {
                this.inventory.set(2, (Object)outputStack.func_77946_l());
            } else if (output.func_77973_b() == outputStack.func_77973_b()) {
                output.func_190917_f(outputStack.func_190916_E());
            }
            fuel.func_190918_g(1);
        }
    }

    protected int getBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel) / 32;
    }

    protected int getCookTime() {
        return 600;
    }

    public static boolean isFuel(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof BucketItem && ((BucketItem)stack.func_77973_b()).getFluid().func_207185_a((ITag)FluidTags.field_206960_b);
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return direction != Direction.DOWN || index != 1;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        ItemStack inventoryStack = (ItemStack)this.inventory.get(index);
        boolean haveInputChanged = !stack.func_190926_b() && stack.func_77969_a(inventoryStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)inventoryStack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !haveInputChanged) {
            this.cookTimeTotal = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() instanceof IArtifact;
        }
        if (index == 1) {
            return GodforgeTileEntity.isFuel(stack);
        }
        return false;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        super.onDataPacket(manager, packet);
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

