/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines;

import com.teammetallurgy.atum.blocks.machines.KilnBlock;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnBaseTileEntity;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class KilnFakeBlock
extends ContainerBlock {
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");

    public KilnFakeBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151658_d).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader reader) {
        return new KilnTileEntity();
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult rayTraceResult) {
        INamedContainerProvider container;
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        BlockPos tepos = this.getPrimaryKilnBlock(world, pos);
        if (tepos != null && (container = this.func_220052_b(world.func_180495_p(tepos), world, tepos)) != null && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)container, (BlockPos)tepos);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockState primaryState;
        BlockPos primaryPos = this.getPrimaryKilnBlock(world, pos);
        if (primaryPos != null && (primaryState = world.func_180495_p(primaryPos)).func_177230_c() == AtumBlocks.KILN && ((Boolean)primaryState.func_177229_b((Property)KilnBlock.MULTIBLOCK_PRIMARY)).booleanValue()) {
            ((KilnBlock)AtumBlocks.KILN).destroyMultiblock(world, primaryPos, (Direction)primaryState.func_177229_b((Property)KilnBlock.field_220090_a));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private BlockPos getPrimaryKilnBlock(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof KilnBaseTileEntity) {
            KilnBaseTileEntity tekb = (KilnBaseTileEntity)te;
            return tekb.getPrimaryPos();
        }
        return null;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AtumBlocks.KILN);
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{UP});
    }
}

