/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.blocks.base.IUnbreakable;
import com.teammetallurgy.atum.blocks.lighting.INebuTorch;
import com.teammetallurgy.atum.blocks.stone.limestone.LimestoneBrickBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.SarcophagusTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class QuandaryBlock
extends Block
implements IUnbreakable {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    private static final BooleanProperty ACTIVATED = BooleanProperty.func_177716_a((String)"activated");

    public QuandaryBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151658_d).func_200948_a(1.5f, 8.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).harvestLevel(1));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UNBREAKABLE, (Comparable)Boolean.valueOf(false)));
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((Property)UNBREAKABLE) != false ? 6000000.0f : super.getExplosionResistance(state, world, pos, explosion);
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        if (world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)FACING))) == world.func_180495_p(fromPos)) {
            Block facingBlock = world.func_180495_p(fromPos).func_177230_c();
            boolean activated = facingBlock instanceof INebuTorch && ((INebuTorch)facingBlock).isNebuTorch();
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(activated)), 2);
            if (activated) {
                Helper.attemptMakeDoor(world, pos, (Direction)state.func_177229_b((Property)FACING), LimestoneBrickBlock.class, null);
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public boolean func_149744_f(@Nonnull BlockState state) {
        return true;
    }

    public int func_176211_b(BlockState blockState, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction direction) {
        return blockState.func_185911_a(world, pos, direction);
    }

    public int func_180656_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction direction) {
        return (Boolean)state.func_177229_b((Property)ACTIVATED) == false ? 0 : 15;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{FACING, ACTIVATED, UNBREAKABLE});
    }

    public static class Helper {
        public static void attemptMakeDoor(World world, BlockPos pos, Direction facing, Class<? extends Block> fullBlock, @Nullable DoorBlock door) {
            if (facing.func_176740_k() != Direction.Axis.Y) {
                BlockState offsetLeft = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), 3));
                BlockState offsetRight = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 3));
                if (offsetLeft.func_177230_c() == AtumBlocks.QUANDARY_BLOCK && ((Boolean)offsetLeft.func_177229_b((Property)ACTIVATED)).booleanValue() || offsetRight.func_177230_c() == AtumBlocks.QUANDARY_BLOCK && ((Boolean)offsetRight.func_177229_b((Property)ACTIVATED)).booleanValue()) {
                    boolean isPrimary = false;
                    if (offsetRight.func_177230_c() == AtumBlocks.QUANDARY_BLOCK) {
                        isPrimary = true;
                    }
                    if (!isPrimary) {
                        pos = pos.func_177967_a(facing.func_176746_e(), 3);
                    }
                    if (Helper.hasEntranceBlocks(world, pos, facing, fullBlock)) {
                        BlockPos rightFromPrimary = pos.func_177972_a(facing.func_176735_f());
                        if (door == null) {
                            ResourceLocation location;
                            Block doorRead;
                            Block readFromBlock = world.func_180495_p(rightFromPrimary).func_177230_c();
                            door = readFromBlock.getRegistryName() != null ? ((doorRead = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((location = readFromBlock.getRegistryName()).func_110624_b(), location.func_110623_a() + "_door"))) != null ? (DoorBlock)doorRead : (DoorBlock)AtumBlocks.LIMESTONE_DOOR) : (DoorBlock)AtumBlocks.LIMESTONE_DOOR;
                        }
                        BlockState doorLeft = (BlockState)((BlockState)((BlockState)door.func_176223_P().func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)facing.func_176734_d())).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true));
                        BlockState doorRight = (BlockState)((BlockState)((BlockState)door.func_176223_P().func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)facing.func_176734_d())).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true));
                        world.func_180501_a(rightFromPrimary, (BlockState)doorLeft.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 3);
                        world.func_180501_a(rightFromPrimary.func_177977_b(), doorLeft, 2);
                        world.func_180501_a(pos.func_177967_a(facing.func_176735_f(), 2), (BlockState)doorRight.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 3);
                        world.func_180501_a(pos.func_177967_a(facing.func_176735_f(), 2).func_177977_b(), doorRight, 2);
                        Helper.playRewardDing(world, pos);
                    }
                }
            }
        }

        public static boolean hasEntranceBlocks(World world, BlockPos pos, Direction facing, Class<? extends Block> fullBlock) {
            Block rightFromPrimary = world.func_180495_p(pos.func_177972_a(facing.func_176735_f())).func_177230_c();
            return fullBlock.isInstance(rightFromPrimary) && world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 2)).func_177230_c() == rightFromPrimary && world.func_180495_p(pos.func_177972_a(facing.func_176735_f()).func_177977_b()).func_177230_c() == rightFromPrimary && world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 2).func_177977_b()).func_177230_c() == rightFromPrimary;
        }

        public static boolean canSpawnPharaoh(World world, BlockPos pos, Direction facing, PlayerEntity player, SarcophagusTileEntity sarcophagus) {
            Block topLeftCorner = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), 2).func_177967_a(facing.func_176734_d(), 1)).func_177230_c();
            Block bottomLeftCorner = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), 2).func_177967_a(facing, 2)).func_177230_c();
            Block topRightCorner = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 3).func_177967_a(facing.func_176734_d(), 1)).func_177230_c();
            Block bottomRightCorner = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 3).func_177967_a(facing, 2)).func_177230_c();
            if (topLeftCorner instanceof INebuTorch && bottomLeftCorner instanceof INebuTorch && topRightCorner instanceof INebuTorch && bottomRightCorner instanceof INebuTorch) {
                INebuTorch torchTopLeftCorner = (INebuTorch)topLeftCorner;
                INebuTorch torchBottomLeftCorner = (INebuTorch)bottomLeftCorner;
                INebuTorch torchTopRightCorner = (INebuTorch)topRightCorner;
                INebuTorch torchBottomRightCorner = (INebuTorch)bottomRightCorner;
                if (torchTopLeftCorner.isNebuTorch() && torchBottomLeftCorner.isNebuTorch() && torchTopRightCorner.isNebuTorch() && torchBottomRightCorner.isNebuTorch()) {
                    Helper.playRewardDing(world, pos);
                    God god = torchTopLeftCorner.getGod();
                    if (god == torchBottomLeftCorner.getGod() && god == torchTopRightCorner.getGod() && god == torchBottomRightCorner.getGod()) {
                        sarcophagus.spawn(player, world.func_175649_E(pos), god);
                    } else {
                        sarcophagus.spawn(player, world.func_175649_E(pos), null);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        public static void playRewardDing(World world, BlockPos pos) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_193808_ex, SoundCategory.BLOCKS, 1.3f, 1.0f);
        }
    }
}

