/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.accumulator;

import com.mrh0.createaddition.blocks.accumulator.AccumulatorTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.index.CATileEntities;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AccumulatorBlock
extends Block
implements ITE<AccumulatorTileEntity>,
IWrenchable {
    public static final VoxelShape ACCUMULATOR_SHAPE_MAIN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape ACCUMULATOR_SHAPE_X = VoxelShapes.func_216384_a((VoxelShape)ACCUMULATOR_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0), Block.func_208617_a((double)11.0, (double)0.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0)});
    public static final VoxelShape ACCUMULATOR_SHAPE_Z = VoxelShapes.func_216384_a((VoxelShape)ACCUMULATOR_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0, (double)5.0), Block.func_208617_a((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)16.0, (double)15.0)});
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public AccumulatorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public Class<AccumulatorTileEntity> getTileEntityClass() {
        return AccumulatorTileEntity.class;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction.Axis axis = ((Direction)state.func_177229_b((Property)FACING)).func_176740_k();
        return axis == Direction.Axis.X ? ACCUMULATOR_SHAPE_X : ACCUMULATOR_SHAPE_Z;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return CATileEntities.ACCUMULATOR.create();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)(c.func_195999_j().func_225608_bj_() ? c.func_195992_f().func_176735_f() : c.func_195992_f().func_176746_e()));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof AccumulatorTileEntity) {
            CompoundNBT nbt;
            AccumulatorTileEntity ate = (AccumulatorTileEntity)te;
            if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("energy")) {
                ate.setEnergy(nbt.func_74762_e("energy"));
            }
        }
        super.func_180633_a(world, pos, state, entity, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (player.func_184812_l_()) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null) {
            return;
        }
        if (!(te instanceof IWireNode)) {
            return;
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(worldIn);
    }

    public ActionResultType onSneakWrenched(BlockState state, ItemUseContext c) {
        if (c.func_195999_j().func_184812_l_()) {
            return super.onSneakWrenched(state, c);
        }
        TileEntity te = c.func_195991_k().func_175625_s(c.func_195995_a());
        if (te == null) {
            return super.onSneakWrenched(state, c);
        }
        if (!(te instanceof IWireNode)) {
            return super.onSneakWrenched(state, c);
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(c.func_195991_k(), c.func_195999_j());
        return super.onSneakWrenched(state, c);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return IComparatorOverride.getComparetorOverride(worldIn, pos);
    }
}

