/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.util;

import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.util.DropSimulationWorld;
import mod.noobulus.tetrapak.util.WrappedServerWorld;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.CastOptional;

public class BlockHelper {
    private BlockHelper() {
    }

    public static void destroyBlockAs(World world, BlockPos pos, @Nullable PlayerEntity player, ItemStack usedTool, float effectChance, BiConsumer<ItemStack, BlockState> droppedItemCallback) {
        World unwrappedWorld = WrappedServerWorld.unwrap(world);
        FluidState fluidState = unwrappedWorld.func_204610_c(pos);
        BlockState state = unwrappedWorld.func_180495_p(pos);
        if (unwrappedWorld.field_73012_v.nextFloat() < effectChance) {
            unwrappedWorld.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
        if (player != null) {
            if (!(usedTool.func_77973_b() instanceof ItemModularHandheld)) {
                usedTool.func_179548_a(unwrappedWorld, state, pos, player);
            }
            BlockHelper.breakBlock(world, player, usedTool, pos);
        } else {
            unwrappedWorld.func_175656_a(pos, fluidState.func_206883_i());
        }
        if (world instanceof DropSimulationWorld) {
            ((DropSimulationWorld)world).getItems().forEach(stack -> droppedItemCallback.accept((ItemStack)stack, state));
        }
    }

    private static boolean breakBlock(World world, @Nonnull PlayerEntity player, ItemStack tool, BlockPos pos) {
        World unwrappedWorld = WrappedServerWorld.unwrap(world);
        BlockState offsetState = unwrappedWorld.func_180495_p(pos);
        ToolType effectiveTool = ItemModularHandheld.getEffectiveTool((BlockState)offsetState);
        float blockHardness = offsetState.func_185887_b((IBlockReader)unwrappedWorld, pos);
        int toolLevel = tool.func_77973_b().getHarvestLevel(tool, effectiveTool, player, offsetState);
        if ((toolLevel >= 0 && toolLevel >= offsetState.func_177230_c().getHarvestLevel(offsetState) || tool.func_150998_b(offsetState)) && blockHardness != -1.0f && BlockHelper.breakBlock(world, player, tool, pos, offsetState, true)) {
            EffectHelper.sendEventToPlayer((ServerPlayerEntity)((ServerPlayerEntity)player), (int)2001, (BlockPos)pos, (int)Block.func_196246_j((BlockState)offsetState));
            CastOptional.cast((Object)tool.func_77973_b(), ItemModularHandheld.class).ifPresent(itemHandheld -> itemHandheld.applyBreakEffects(tool, unwrappedWorld, offsetState, pos, (LivingEntity)player));
            return true;
        }
        return false;
    }

    public static boolean breakBlock(World world, PlayerEntity breakingPlayer, ItemStack toolStack, BlockPos pos, BlockState blockState, boolean harvest) {
        World unwrappedWorld = WrappedServerWorld.unwrap(world);
        if (!unwrappedWorld.field_72995_K && unwrappedWorld instanceof ServerWorld) {
            boolean canRemove;
            ServerWorld serverWorld = (ServerWorld)unwrappedWorld;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)breakingPlayer;
            GameType gameType = serverPlayer.field_71134_c.func_73081_b();
            int exp = ForgeHooks.onBlockBreakEvent((World)serverWorld, (GameType)gameType, (ServerPlayerEntity)serverPlayer, (BlockPos)pos);
            TileEntity tileEntity = serverWorld.func_175625_s(pos);
            if (exp == -1) {
                return false;
            }
            boolean bl = canRemove = !toolStack.onBlockStartBreak(pos, breakingPlayer) && !breakingPlayer.func_223729_a((World)serverWorld, pos, gameType) && (!harvest || blockState.canHarvestBlock((IBlockReader)serverWorld, pos, breakingPlayer)) && blockState.func_177230_c().removedByPlayer(blockState, (World)serverWorld, pos, breakingPlayer, harvest, serverWorld.func_204610_c(pos));
            if (canRemove) {
                blockState.func_177230_c().func_176206_d((IWorld)serverWorld, pos, blockState);
                if (harvest) {
                    blockState.func_177230_c().func_180657_a(world, breakingPlayer, pos, blockState, tileEntity, toolStack);
                    if (exp > 0) {
                        blockState.func_177230_c().func_180637_b(serverWorld, pos, exp);
                    }
                }
            }
            return canRemove;
        }
        return blockState.func_177230_c().removedByPlayer(blockState, unwrappedWorld, pos, breakingPlayer, harvest, unwrappedWorld.func_204610_c(pos));
    }
}

