/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.quark;

import mod.noobulus.tetrapak.Config;
import mod.noobulus.tetrapak.quark.CorundumMap;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.getter.ILabelGetter;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;

public class CorundumEffect
implements IHoloDescription,
IEventBusListener {
    public CorundumEffect() {
        CorundumMap.checkMappings();
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("rainbow");
    }

    @SubscribeEvent
    public void corundumToolsBreakBlocksFaster(PlayerEvent.BreakSpeed event) {
        int effectLevel = this.getEffectLevel(event.getPlayer().func_184614_ca());
        if (effectLevel <= 0) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getEntityLiving().field_70170_p;
        boolean matches = CorundumMap.COLOR_MAP.get(world.func_180495_p(event.getPos()).func_185909_g((IBlockReader)world, pos)) == effectLevel;
        event.setNewSpeed((float)((double)event.getOriginalSpeed() * (matches ? (Double)Config.MATCHING_CRYSTAL_FACTOR.get() : (Double)Config.NON_MATCHING_CRYSTAL_FACTOR.get())));
    }

    @Override
    public ITooltipGetter getStatTooltipGetter(IStatGetter statGetter) {
        return (player, itemStack) -> I18n.func_135052_a((String)this.getTooltipPath(), (Object[])new Object[]{new TranslationTextComponent("tetrapak." + CorundumMap.NAME_MAP.get((int)statGetter.getValue(player, itemStack))).getString(), Config.MATCHING_CRYSTAL_FACTOR.get()});
    }

    @Override
    public ILabelGetter getStatLabel() {
        return new LabelGetterBasic("%s", "%s"){

            public String getLabel(double value, double diffValue, boolean flipped) {
                return new TranslationTextComponent("tetrapak." + CorundumMap.NAME_MAP.get((int)diffValue)).getString();
            }
        };
    }
}

