/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.predicate;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.TetraPak;
import mod.noobulus.tetrapak.predicate.AbstractPredicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public abstract class AbstractPredicateManager<T extends AbstractPredicate<?, T>> {
    private final Class<T> registryClass;
    private final String registryName;
    protected IForgeRegistry<T> registry = null;

    public AbstractPredicateManager(Class<T> registryClass, String registryName) {
        this.registryClass = registryClass;
        this.registryName = registryName;
    }

    @SubscribeEvent
    public void onNewRegistry(RegistryEvent.NewRegistry event) {
        this.registry = new RegistryBuilder().setType(this.registryClass).setName(TetraPak.asId(this.registryName)).create();
    }

    @SubscribeEvent
    public void onRegisterPredicates(RegistryEvent.Register<T> event) {
        this.registerContents(event.getRegistry());
    }

    public void registerContents(IForgeRegistry<T> registry) {
    }

    @Nullable
    public IForgeRegistry<T> getRegistry() {
        return this.registry;
    }

    public AbstractPredicateManager<T> register(IEventBus modEventBus) {
        modEventBus.addGenericListener(this.registryClass, this::onRegisterPredicates);
        modEventBus.addListener(this::onNewRegistry);
        return this;
    }

    public static class Builder<T extends AbstractPredicate<?, T>> {
        private final Map<ResourceLocation, Supplier<T>> registryObjects;
        private final Class<T> registryClass;
        private final String registryName;

        public Builder(Class<T> registryClass, String registryName) {
            this.registryClass = registryClass;
            this.registryName = registryName;
            this.registryObjects = new HashMap<ResourceLocation, Supplier<T>>();
        }

        public Builder<T> queue(String id, Supplier<T> supplier) {
            return this.queue(TetraPak.asId(id), supplier);
        }

        public Builder<T> queue(ResourceLocation id, Supplier<T> supplier) {
            this.registryObjects.put(id, supplier);
            return this;
        }

        public AbstractPredicateManager<T> build() {
            return new AbstractPredicateManager<T>(this.registryClass, this.registryName){

                @Override
                public void registerContents(IForgeRegistry<T> registry) {
                    registryObjects.forEach((name, supplier) -> registry.register(((AbstractPredicate)((Object)((Object)supplier.get()))).setRegistryName((ResourceLocation)name)));
                }
            }.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }
}

