/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.mixin;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.noobulus.tetrapak.predicate.PredicateManagers;
import net.minecraft.advancements.criterion.DistancePredicate;
import net.minecraft.advancements.criterion.EntityEquipmentPredicate;
import net.minecraft.advancements.criterion.EntityFlagsPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.EntityTypePredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MobEffectsPredicate;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.advancements.criterion.PlayerPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.loot.FishingPredicate;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPredicate.class})
public class EntityPredicateMixin {
    private final List<Predicate<Entity>> customPredicates = new ArrayList<Predicate<Entity>>();

    @Inject(at={@At(value="RETURN")}, method={"fromJson"}, cancellable=true)
    private static void onFromJson(JsonElement element, CallbackInfoReturnable<EntityPredicate> cir) {
        if (PredicateManagers.ENTITY_PREDICATES.getRegistry() == null) {
            return;
        }
        List<Predicate<Entity>> predicateList = PredicateManagers.ENTITY_PREDICATES.getRegistry().getValues().stream().map(abstractEntityPredicate -> abstractEntityPredicate.read(element)).filter(Objects::nonNull).collect(Collectors.toList());
        if (predicateList.isEmpty()) {
            return;
        }
        EntityPredicate predicate = (EntityPredicate)cir.getReturnValue();
        if (predicate == EntityPredicate.field_192483_a) {
            predicate = new EntityPredicate(EntityTypePredicate.field_209371_a, DistancePredicate.field_193423_a, LocationPredicate.field_193455_a, MobEffectsPredicate.field_193473_a, NBTPredicate.field_193479_a, EntityFlagsPredicate.field_217979_a, EntityEquipmentPredicate.field_217958_a, PlayerPredicate.field_226989_a_, FishingPredicate.field_234635_a_, null, null);
            cir.setReturnValue((Object)predicate);
        }
        ((EntityPredicateMixin)predicate).bindPredicateList(predicateList);
    }

    @Inject(at={@At(value="RETURN")}, method={"matches(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/vector/Vector3d;Lnet/minecraft/entity/Entity;)Z"}, cancellable=true)
    private void onPredicateTest(ServerWorld level, Vector3d vector3d, Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (this.customPredicates.isEmpty() || !cir.getReturnValueZ()) {
            return;
        }
        cir.setReturnValue((Object)this.customPredicates.stream().allMatch(entityPredicate -> entityPredicate.test(entity)));
    }

    public void bindPredicateList(List<Predicate<Entity>> list) {
        this.customPredicates.addAll(list);
    }
}

