/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.animations.AnimatedDeployer;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mod.noobulus.tetrapak.TetraPak;
import mod.noobulus.tetrapak.create.recipes.SalvagingRecipe;
import mod.noobulus.tetrapak.jei.CompatJeiRecipe;
import mod.noobulus.tetrapak.jei.JeiTooltipEntry;
import mod.noobulus.tetrapak.util.LootLoader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.items.modular.IModularItem;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AutoSalvageCategory
implements CompatJeiRecipe<SalvagingRecipe> {
    public static final ResourceLocation ID = TetraPak.asId("auto_salvage");
    private static final ItemStack hammer = AutoSalvageCategory.makeHammer();
    private final IDrawable background = new EmptyBackground(177, 90);
    private final IDrawable icon = new DoubleItemIcon(() -> new ItemStack((IItemProvider)AllBlocks.DEPLOYER.get()), () -> hammer);
    private final AnimatedDeployer deployer = new AnimatedDeployer();

    private static ItemStack makeHammer() {
        Item modularDouble = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:modular_double"));
        if (modularDouble == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)modularDouble);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_left", (String)"double/basic_hammer_left", (String)"double/basic_hammer_left_material", (String)"basic_hammer/iron");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_right", (String)"double/basic_hammer_right", (String)"double/basic_hammer_right_material", (String)"basic_hammer/iron");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/handle", (String)"double/basic_handle", (String)"double/basic_handle_material", (String)"basic_handle/spruce");
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends SalvagingRecipe> getRecipeClass() {
        return SalvagingRecipe.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SalvagingRecipe salvagingRecipe, IIngredients iIngredients) {
        iIngredients.setInputIngredients(Arrays.asList(salvagingRecipe.startingItem, Ingredient.func_234819_a_(salvagingRecipe.toolExamples.get().stream())));
        iIngredients.setOutputs(VanillaTypes.ITEM, salvagingRecipe.contents.get().stream().map(LootLoader.LootSlot::asStack).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, SalvagingRecipe salvagingRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, true, 26, 66);
        itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.init(1, true, 50, 19);
        itemStacks.set(1, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(1));
        Map<ItemStack, Supplier> tooltips = salvagingRecipe.contents.get().stream().collect(Collectors.toMap(LootLoader.LootSlot::asStack, lootSlot -> lootSlot));
        ArrayList<ItemStack> entries = new ArrayList<ItemStack>(tooltips.keySet());
        for (int i = 0; i < entries.size(); ++i) {
            int xOffset = i % 2 == 0 ? 0 : 19;
            int yOffset = i / 2 * -19;
            itemStacks.init(i + 2, false, 117 + xOffset, 67 + yOffset);
            itemStacks.set(i + 2, (ItemStack)entries.get(i));
        }
        ((List)iIngredients.getInputs(VanillaTypes.ITEM).get(1)).stream().findFirst().ifPresent(t -> tooltips.put((ItemStack)t, () -> new TranslationTextComponent("tetrapak.tool_type." + salvagingRecipe.toolType.getName())));
        iRecipeLayout.getItemStacks().addTooltipCallback(new JeiTooltipEntry<ItemStack>(tooltips));
    }

    @Override
    public IRecipeType<SalvagingRecipe> getRecipeType() {
        return SalvagingRecipe.SalvagingRecipeType.AUTOMATIC_SALVAGING;
    }

    @Override
    public Collection<ItemStack> getCatalystIcons() {
        return Collections.singletonList(new ItemStack((IItemProvider)AllBlocks.DEPLOYER.get()));
    }

    public void draw(SalvagingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 50, 19);
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 26, 65);
        AllGuiTextures.JEI_SHADOW.draw(matrixStack, 62, 72);
        this.deployer.draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 37);
    }
}

