/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.create.refined_radiance;

import mod.noobulus.tetrapak.networking.EntityFloatParticlePacket;
import mod.noobulus.tetrapak.networking.Packets;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import se.mickelus.tetra.effect.ItemEffect;

public class FloatingEffect
implements IHoloDescription,
IEventBusListener {
    public static final FloatingEffect INSTANCE = new FloatingEffect();
    private boolean makeItemsFloat = false;

    private static void makeFloaty(Entity e) {
        e.func_189654_d(true);
        e.func_213317_d(e.func_213322_ci().func_186678_a(0.3));
        e.getPersistentData().func_74757_a("DoFloatyParticles", true);
    }

    public static float getIdleParticleChance(ItemEntity entity) {
        return (float)MathHelper.func_76125_a((int)(entity.func_92059_d().func_190916_E() - 10), (int)5, (int)100) / 64.0f;
    }

    public static void onItemEntityTick(ItemEntity entity) {
        World world = entity.func_130014_f_();
        if (entity.field_70170_p == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!entity.getPersistentData().func_74767_n("DoFloatyParticles")) {
            return;
        }
        if (world.field_73012_v.nextFloat() > FloatingEffect.getIdleParticleChance(entity)) {
            return;
        }
        Packets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new EntityFloatParticlePacket((Entity)entity));
    }

    public void checkFloatiness(ItemStack tool) {
        this.makeItemsFloat = this.hasEffect(tool);
    }

    public void checkFloatiness(DamageSource source) {
        this.makeItemsFloat = this.hasEffect(source);
    }

    @SubscribeEvent
    public void floatingKillsLevitateDrops(LivingDropsEvent event) {
        if (this.hasEffect(event.getSource())) {
            event.getDrops().forEach(FloatingEffect::makeFloaty);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof ItemEntity)) {
            return;
        }
        if (this.makeItemsFloat || this.hasEffect(((ItemEntity)event.getEntity()).func_92059_d())) {
            FloatingEffect.makeFloaty(event.getEntity());
        }
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("floating");
    }

    public void resetFloatiness() {
        this.makeItemsFloat = false;
    }
}

