/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.create.refined_radiance;

import java.util.HashSet;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.create.refined_radiance.BlockCollection;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import se.mickelus.tetra.effect.ItemEffect;

public class CollapsingEffect
implements IHoloDescription,
IEventBusListener {
    private static boolean collapsing = false;

    public static void collapse(IWorld iWorld, BlockPos pos, PlayerEntity entity) {
        if (collapsing || entity.func_225608_bj_() || !(iWorld instanceof World)) {
            return;
        }
        World world = (World)iWorld;
        collapsing = true;
        CollapsingEffect.findDirtCollumn((IBlockReader)world, pos).destroyBlocksFancy(world, (LivingEntity)entity);
        collapsing = false;
    }

    public static BlockCollection findDirtCollumn(@Nullable IBlockReader world, BlockPos pos) {
        if (world == null) {
            return BlockCollection.EMPTY;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockState startState = world.func_180495_p(pos);
        while (CollapsingEffect.canBreakWithStart(startState, world.func_180495_p(pos))) {
            visited.add(pos);
            pos = pos.func_177984_a();
        }
        return new BlockCollection(visited);
    }

    public static boolean canBreakWithStart(BlockState start, BlockState test) {
        if (!ToolType.SHOVEL.equals(test.getHarvestTool())) {
            return false;
        }
        if (test.func_177230_c() instanceof FallingBlock) {
            return true;
        }
        if (start.func_177230_c().equals(test.func_177230_c())) {
            return true;
        }
        return Material.field_151578_c.equals(CollapsingEffect.getBlockMaterial(start)) && (Material.field_151578_c.equals(CollapsingEffect.getBlockMaterial(test)) || test.func_177230_c().equals(Blocks.field_196658_i));
    }

    @Nullable
    private static Material getBlockMaterial(BlockState state) {
        Object mat = ObfuscationReflectionHelper.getPrivateValue(AbstractBlock.class, (Object)state.func_177230_c(), (String)"field_149764_J");
        return mat instanceof Material ? (Material)mat : null;
    }

    @SubscribeEvent
    public void collapseWhenBlockBroken(BlockEvent.BreakEvent event) {
        if (!collapsing && this.hasEffect(event.getPlayer().func_184614_ca())) {
            CollapsingEffect.collapse(event.getWorld(), event.getPos(), event.getPlayer());
        }
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("collapsing");
    }
}

