/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.create.refined_radiance;

import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.entities.FragileFallingBlock;
import mod.noobulus.tetrapak.util.BlockHelper;
import mod.noobulus.tetrapak.util.DropSimulationWorld;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.util.TriConsumer;

public class BlockCollection
extends AbstractBlockBreakQueue {
    public static final BlockCollection EMPTY = new BlockCollection(Collections.emptyList());
    private final Collection<BlockPos> blocks;

    public BlockCollection(Collection<BlockPos> blocks) {
        this.blocks = blocks;
    }

    public void destroyBlocks(World world, ItemStack itemStack, @Nullable PlayerEntity playerEntity, TriConsumer<BlockPos, BlockState, ItemStack> drop) {
        this.blocks.forEach(this.makeCallbackFor(world, 0.125f, itemStack, playerEntity, drop));
    }

    public void destroyBlocks(World world, @Nullable LivingEntity entity, TriConsumer<BlockPos, BlockState, ItemStack> drop) {
        PlayerEntity playerEntity = entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
        ItemStack toDamage = playerEntity != null && !playerEntity.func_184812_l_() ? playerEntity.func_184614_ca() : ItemStack.field_190927_a;
        this.destroyBlocks(world, toDamage, playerEntity, drop);
    }

    public void destroyBlocksFancy(World world, @Nullable LivingEntity entity) {
        HashMap<Pair, Collection> drops = new HashMap<Pair, Collection>();
        this.destroyBlocks(world, entity, (TriConsumer<BlockPos, BlockState, ItemStack>)((TriConsumer)(pos, state, stack) -> {
            Pair key = Pair.of((Object)pos, (Object)state);
            Collection<ItemStack> dropsAt = drops.containsKey(key) ? (Collection)drops.get(key) : new ArrayList();
            dropsAt.add((ItemStack)stack);
            drops.put(key, dropsAt);
        }));
        if (!world.field_72995_K) {
            drops.forEach((inf, itemStacks) -> world.func_217376_c((Entity)new FragileFallingBlock(world, (BlockPos)inf.getFirst(), (BlockState)inf.getSecond(), (Collection<ItemStack>)itemStacks)));
        }
    }

    protected Consumer<BlockPos> makeCallbackFor(World world, float effectChance, ItemStack toDamage, @Nullable PlayerEntity playerEntity, TriConsumer<BlockPos, BlockState, ItemStack> drop) {
        World simulationWorld = DropSimulationWorld.of(world);
        return pos -> {
            ItemStack usedTool = toDamage.func_77946_l();
            BlockHelper.destroyBlockAs(simulationWorld, pos, playerEntity, toDamage, effectChance, (stack, state) -> drop.accept(pos, state, stack));
            if (toDamage.func_190926_b() && !usedTool.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)playerEntity, (ItemStack)usedTool, (Hand)Hand.MAIN_HAND);
            }
        };
    }

    public void destroyBlocks(World world, ItemStack itemStack, @Nullable PlayerEntity playerEntity, BiConsumer<BlockPos, ItemStack> biConsumer) {
        this.destroyBlocks(world, itemStack, playerEntity, (TriConsumer<BlockPos, BlockState, ItemStack>)((TriConsumer)(pos, state, stack) -> biConsumer.accept((BlockPos)pos, (ItemStack)stack)));
    }
}

