/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.create.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mod.noobulus.tetrapak.TetraPak;
import mod.noobulus.tetrapak.util.LootLoader;
import mod.noobulus.tetrapak.util.RecalculatableLazyValue;
import mod.noobulus.tetrapak.util.ToolHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SalvagingRecipe
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    private static final LootParameterSet lootParameters = new LootParameterSet.Builder().func_216269_a(LootParameters.field_237457_g_).func_216271_b(LootParameters.field_216289_i).func_216271_b(LootParameters.field_216281_a).func_216270_a();
    public final ToolType toolType;
    public final int toolLevel;
    public final Ingredient startingItem;
    public final ResourceLocation lootTable;
    public final RecalculatableLazyValue<List<LootLoader.LootSlot>> contents;
    public final RecalculatableLazyValue<List<ItemStack>> toolExamples;
    private final ResourceLocation id;
    @Nullable
    private DeployerAwareInventory recipeInv;

    public SalvagingRecipe(ResourceLocation id, ToolType toolType, int toolLevel, Ingredient startingItem, ResourceLocation lootTable) {
        this.id = id;
        this.toolType = toolType;
        this.toolLevel = toolLevel;
        this.startingItem = startingItem;
        this.lootTable = lootTable;
        this.contents = new RecalculatableLazyValue((NonNullSupplier)DistExecutor.unsafeRunForDist(() -> () -> () -> {
            if (Minecraft.func_71410_x().func_71356_B()) {
                return this.getContents();
            }
            return new ArrayList();
        }, () -> () -> this::getContents));
        this.toolExamples = new RecalculatableLazyValue(() -> ToolHelper.getToolsOf(toolType, toolLevel));
    }

    public boolean func_77569_a(IInventory iInventory, World level) {
        if (iInventory.func_70302_i_() != 2) {
            return false;
        }
        ItemStack toolSlot = iInventory.func_70301_a(0);
        if (toolSlot.func_190926_b()) {
            return false;
        }
        if (toolSlot.func_77973_b().getHarvestLevel(toolSlot, this.toolType, null, null) < this.toolLevel) {
            return false;
        }
        return this.startingItem.test(iInventory.func_70301_a(1));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public List<ItemStack> rollResults(IInventory iInventory, ServerWorld level, @Nullable PlayerEntity playerEntity) {
        if (iInventory.func_70302_i_() != 2) {
            return new ArrayList<ItemStack>();
        }
        ItemStack toolSlot = iInventory.func_70301_a(0);
        if (toolSlot.func_190926_b()) {
            return new ArrayList<ItemStack>();
        }
        LootContext.Builder builder = new LootContext.Builder(level).func_216015_a(LootParameters.field_216289_i, (Object)toolSlot);
        if (playerEntity != null) {
            builder.func_216015_a(LootParameters.field_216281_a, (Object)playerEntity).func_216015_a(LootParameters.field_237457_g_, (Object)playerEntity.func_213303_ch()).func_186469_a(playerEntity.func_184817_da());
        }
        LootTable table = level.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
        return table.func_216113_a(builder.func_216022_a(lootParameters));
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return SalvagingRecipeType.AUTOMATIC_SALVAGING;
    }

    public void setBufferedInv(DeployerAwareInventory recipeInv) {
        this.recipeInv = recipeInv;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nullable
    public DeployerAwareInventory getRecipeInv() {
        return this.recipeInv;
    }

    private List<LootLoader.LootSlot> getContents() {
        LootTableManager manager = LootLoader.getManager();
        return LootLoader.crawlTable(manager.func_186521_a(this.lootTable), manager);
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SalvagingRecipe> {
        private Serializer() {
        }

        public SalvagingRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("requirement"));
            int toolLevel = JSONUtils.func_151204_g((JsonObject)json, (String)"tool_level") ? JSONUtils.func_151203_m((JsonObject)json, (String)"tool_level") : 0;
            ToolType toolType = ToolType.get((String)JSONUtils.func_151200_h((JsonObject)json, (String)"tool_type"));
            ResourceLocation lootTable = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"lootTable"));
            return new SalvagingRecipe(id, toolType, toolLevel, ingredient, lootTable);
        }

        @Nullable
        public SalvagingRecipe fromNetwork(ResourceLocation id, PacketBuffer packetBuffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)packetBuffer);
            int toolLevel = packetBuffer.readInt();
            ResourceLocation lootTable = packetBuffer.func_192575_l();
            ToolType toolType = ToolType.get((String)packetBuffer.func_150789_c(Short.MAX_VALUE));
            SalvagingRecipe recipe = new SalvagingRecipe(id, toolType, toolLevel, ingredient, lootTable);
            int slotCount = packetBuffer.readInt();
            ArrayList<LootLoader.LootSlot> slots = new ArrayList<LootLoader.LootSlot>();
            for (int i = 0; i < slotCount; ++i) {
                slots.add(new LootLoader.LootSlot(packetBuffer));
            }
            recipe.contents.updateSupplier((NonNullSupplier<List<LootLoader.LootSlot>>)((NonNullSupplier)() -> slots));
            int exampleCount = packetBuffer.readInt();
            ArrayList<ItemStack> examples = new ArrayList<ItemStack>();
            for (int i = 0; i < exampleCount; ++i) {
                examples.add(packetBuffer.func_150791_c());
            }
            recipe.toolExamples.updateSupplier((NonNullSupplier<List<ItemStack>>)((NonNullSupplier)() -> examples));
            return recipe;
        }

        public void toNetwork(PacketBuffer packetBuffer, SalvagingRecipe recipe) {
            recipe.startingItem.func_199564_a(packetBuffer);
            packetBuffer.writeInt(recipe.toolLevel);
            packetBuffer.func_192572_a(recipe.lootTable);
            packetBuffer.func_180714_a(recipe.toolType.getName());
            List<LootLoader.LootSlot> slots = recipe.contents.get();
            packetBuffer.writeInt(slots.size());
            slots.forEach(slot -> slot.toBuffer(packetBuffer));
            List<ItemStack> examples = recipe.toolExamples.get();
            packetBuffer.writeInt(examples.size());
            examples.forEach(tool -> packetBuffer.writeItemStack(tool, false));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="tetrapak")
    public static class SalvagingRecipeType
    implements IRecipeType<SalvagingRecipe> {
        public static final IRecipeType<SalvagingRecipe> AUTOMATIC_SALVAGING = new SalvagingRecipeType();

        private SalvagingRecipeType() {
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)TetraPak.asId("automatic_salvaging"), AUTOMATIC_SALVAGING);
            event.getRegistry().register(SERIALIZER.setRegistryName(TetraPak.asId("automatic_salvaging")));
        }
    }

    public static class DeployerAwareInventory
    extends RecipeWrapper {
        public final DeployerTileEntity deployerTileEntity;
        public final DeployerFakePlayer deployerFakePlayer;
        public final Consumer<List<Item>> onRecipeApply;

        public DeployerAwareInventory(IItemHandlerModifiable inv, DeployerTileEntity deployerTileEntity, DeployerFakePlayer deployerFakePlayer, Consumer<List<Item>> onRecipeApply) {
            super(inv);
            this.deployerTileEntity = deployerTileEntity;
            this.deployerFakePlayer = deployerFakePlayer;
            this.onRecipeApply = onRecipeApply;
        }
    }
}

