/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.create;

import java.util.function.Function;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.Registry;
import mod.noobulus.tetrapak.loot.modifier.VoidingLootModifier;
import mod.noobulus.tetrapak.util.DamageBufferer;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ILootModifier;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.StatGetterEnchantmentLevel;

public class VoidingEffect
implements IHoloDescription,
ILootModifier<VoidingLootModifier>,
IEventBusListener {
    @SubscribeEvent
    public void voidingKillsMultiplyExp(LivingExperienceDropEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource lastActive = DamageBufferer.getLastActiveDamageSource();
        if (this.shouldVoidingAffect(lastActive, (Entity)target)) {
            int levelLooting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)event.getAttackingPlayer().func_184614_ca());
            double modifier = 1.0 + this.getEffectEfficiency(lastActive) * (double)(levelLooting + 2);
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * modifier));
        }
    }

    @SubscribeEvent
    public void voidingHardBlocksGivesExp(BlockEvent.BreakEvent event) {
        ItemStack heldItemMainhand = event.getPlayer().func_184614_ca();
        if (this.hasEffect(heldItemMainhand)) {
            int levelFortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItemMainhand);
            double efficiency = this.getEffectEfficiency(heldItemMainhand);
            double modifier = 1.0 + efficiency * (double)(levelFortune + 2);
            float hardness = event.getState().func_185887_b((IBlockReader)event.getWorld(), event.getPos());
            double hardnessExp = 0.0;
            if ((double)hardness > 3.1) {
                hardnessExp = (double)0.1f * ((double)hardness * (1.0 + efficiency));
            }
            event.setExpToDrop((int)((double)event.getExpToDrop() * modifier + hardnessExp));
        }
    }

    @SubscribeEvent
    public void voidingKillsRemoveDrops(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (!this.shouldVoidingAffect(event.getSource(), entity)) {
            return;
        }
        event.getDrops().clear();
        if (entity instanceof WitherEntity) {
            ItemEntity drop = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)Registry.PLAYING_WITH_POWER_DISC.get(), 1));
            drop.func_174869_p();
            event.getDrops().add(drop);
        }
    }

    private boolean shouldVoidingAffect(@Nullable DamageSource source, Entity target) {
        if (target instanceof PlayerEntity) {
            return false;
        }
        return this.hasEffect(source);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiStatBar getStatBar() {
        StatGetterEffectLevel voidingGetter = new StatGetterEffectLevel(this.getEffect(), 1.0, 0.0);
        StatGetterEffectEfficiency voidingEffGetter = new StatGetterEffectEfficiency(this.getEffect(), 1.0);
        StatGetterEnchantmentLevel voidingLootingGetter = new StatGetterEnchantmentLevel(Enchantments.field_185304_p, 1.0);
        StatGetterEnchantmentLevel voidingFortuneGetter = new StatGetterEnchantmentLevel(Enchantments.field_185308_t, 1.0);
        return new GuiStatBar(0, 0, 59, this.getStatsPath(), 0.0, 1.0, false, (IStatGetter)voidingGetter, LabelGetterBasic.integerLabel, (arg_0, arg_1) -> this.lambda$getStatBar$0((IStatGetter)voidingEffGetter, (IStatGetter)voidingLootingGetter, (IStatGetter)voidingFortuneGetter, arg_0, arg_1));
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("voiding");
    }

    @Override
    public Function<ILootCondition[], VoidingLootModifier> getModifierConstructor() {
        return VoidingLootModifier::new;
    }

    private /* synthetic */ String lambda$getStatBar$0(IStatGetter voidingEffGetter, IStatGetter voidingLootingGetter, IStatGetter voidingFortuneGetter, PlayerEntity player, ItemStack itemStack) {
        return I18n.func_135052_a((String)this.getTooltipPath(), (Object[])new Object[]{1.0 + voidingEffGetter.getValue(player, itemStack) * (voidingLootingGetter.getValue(player, itemStack) + 2.0), 1.0 + voidingEffGetter.getValue(player, itemStack) * (voidingFortuneGetter.getValue(player, itemStack) + 2.0)});
    }
}

