/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tetrapak", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec.DoubleValue MATCHING_CRYSTAL_FACTOR;
    public static final ForgeConfigSpec.DoubleValue NON_MATCHING_CRYSTAL_FACTOR;
    public static final ForgeConfigSpec.IntValue MAX_RADIANT_BLOCKS;

    private Config() {
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        ForgeConfigSpec.Builder commonBuilder = new ForgeConfigSpec.Builder();
        commonBuilder.comment("Quark compatibility settings").push("quark");
        MATCHING_CRYSTAL_FACTOR = commonBuilder.comment("Matching Crystal color mining speed factor").defineInRange("matching_crystal_factor", 1.5, 0.0, 10.0);
        NON_MATCHING_CRYSTAL_FACTOR = commonBuilder.comment("Non-matching Crystal color mining speed factor").defineInRange("non_matching_crystal_factor", 0.5, 0.0, 10.0);
        commonBuilder.pop();
        commonBuilder.comment("Create compatibility settings").push("create");
        MAX_RADIANT_BLOCKS = commonBuilder.comment("Max block count for Refined Radiance mass harvesting").defineInRange("max_radiant_blocks", 512, 0, 4096);
        commonBuilder.pop();
        COMMON_CONFIG = commonBuilder.build();
    }
}

