/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.items;

import com.mgen256.al.FireTypes;
import com.mgen256.al.blocks.FireBase;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.Pedestal;
import com.mgen256.al.items.Wand;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.World;

public class SoulWand
extends Wand {
    private static Item.Properties createProps() {
        Item.Properties p = new Item.Properties();
        p.setNoRepair();
        p.func_200917_a(1);
        p.func_200915_b(1);
        return p;
    }

    public SoulWand() {
        super(SoulWand.createProps());
        this.setRegistryName("soul_wand");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockPos underPos;
        Block underBlock;
        ItemStack stack = playerIn.func_184586_b(handIn);
        BlockRayTraceResult rayTraceResult = SoulWand.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        BlockRayTraceResult blockRayTraceResult = rayTraceResult;
        BlockPos pos = blockRayTraceResult.func_216350_a();
        BlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IHasFire) {
            this.changeFire(worldIn, playerIn, pos, state, (IHasFire)block);
        } else if (block instanceof FireBase && (underBlock = worldIn.func_180495_p(underPos = pos.func_177977_b()).func_177230_c()) instanceof IHasFire) {
            this.changeFire(worldIn, playerIn, underPos, worldIn.func_180495_p(underPos), (IHasFire)underBlock);
        }
        return new ActionResult(ActionResultType.CONSUME, (Object)stack);
    }

    private void changeFire(World worldIn, PlayerEntity playerIn, BlockPos pos, BlockState state, IHasFire modblock) {
        FireTypes currentType = (FireTypes)((Object)state.func_177229_b(IHasFire.FIRE_TYPE));
        FireTypes prevType = (FireTypes)((Object)state.func_177229_b(IHasFire.PREVIOUS_FIRE_TYPE));
        if (prevType == FireTypes.SOUL) {
            prevType = FireTypes.NORMAL;
        }
        if (playerIn.func_225608_bj_()) {
            if (currentType == FireTypes.SOUL) {
                state = modblock.setFireType(worldIn, pos, state, prevType, prevType);
                this.playSound(worldIn, playerIn, Wand.SoundEvents.UNDO, 0.6f);
            }
        } else if (currentType != FireTypes.SOUL) {
            state = modblock.setFireType(worldIn, pos, state, FireTypes.SOUL, prevType);
            this.playSound(worldIn, playerIn, Wand.SoundEvents.CHANGE, 0.8f);
        }
        if (modblock instanceof Pedestal) {
            ((Pedestal)modblock).setFire(worldIn, pos, state, true);
        }
    }
}

