/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.booster;

import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;
import se.mickelus.tetra.util.CastOptional;

public class UtilBooster {
    public static final String activeKey = "booster.active";
    public static final String chargedKey = "booster.charged";
    public static final String fuelKey = "booster.fuel";
    public static final String bufferKey = "booster.buffer";
    public static final String cooldownKey = "booster.cooldown";
    public static final int fuelCapacity = 110;
    public static final int fuelCost = 1;
    public static final int fuelCostCharged = 40;
    public static final int fuelRecharge = 1;
    public static final int cooldownTicks = 20;
    public static final int gunpowderGain = 80;
    public static final float boostStrength = 0.04f;
    public static final float chargedBoostStrength = 1.2f;
    public static final float boostLevelMultiplier = 0.4f;

    public static boolean hasBooster(PlayerEntity player) {
        ItemStack itemStack = ToolbeltHelper.findToolbelt(player);
        return UtilBooster.canBoost(itemStack);
    }

    public static boolean canBoost(ItemStack itemStack) {
        return UtilBooster.getBoosterLevel(itemStack) > 0;
    }

    public static int getBoosterLevel(ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IModularItem) {
            IModularItem item = (IModularItem)itemStack.func_77973_b();
            return item.getEffectLevel(itemStack, ItemEffect.booster);
        }
        return 0;
    }

    public static boolean hasFuel(CompoundNBT tag, boolean charged) {
        if (charged) {
            return tag.func_74762_e(fuelKey) >= 40;
        }
        return tag.func_74762_e(fuelKey) >= 1;
    }

    public static int getFuel(CompoundNBT tag) {
        return tag.func_74762_e(fuelKey);
    }

    public static float getFuelPercent(CompoundNBT tag) {
        return (float)tag.func_74762_e(fuelKey) * 1.0f / 110.0f;
    }

    public static void boostPlayer(PlayerEntity player, CompoundNBT tag, int level) {
        float boostBase = 0.04f + 0.04f * (float)(level - 1) * 0.4f;
        if (player.func_184613_cA()) {
            Vector3d Vector3d2 = player.func_70040_Z();
            player.func_70024_g(Vector3d2.field_72450_a * (double)0.01f + (Vector3d2.field_72450_a * 1.5 - player.func_213322_ci().field_72450_a) * (double)0.05f, Vector3d2.field_72448_b * (double)0.01f + (Vector3d2.field_72448_b * 1.5 - player.func_213322_ci().field_72448_b) * (double)0.05f, Vector3d2.field_72449_c * (double)0.01f + (Vector3d2.field_72449_c * 1.5 - player.func_213322_ci().field_72449_c) * (double)0.05f);
        } else if (player.func_213322_ci().field_72448_b > -0.1) {
            if (player.func_213453_ef()) {
                player.func_70024_g(0.0, (double)boostBase / 1.5, 0.0);
            } else {
                player.func_70024_g(0.0, (double)boostBase, 0.0);
            }
            player.field_70143_R = 0.0f;
        } else {
            player.func_70024_g(0.0, (double)boostBase + 0.8 * -player.func_213322_ci().field_72448_b, 0.0);
        }
        if (player.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197601_L, player.func_226277_ct_() - 0.2 + Math.random() * 0.4, player.func_226278_cu_() + Math.random() * 0.2, player.func_226281_cx_() - 0.2 + Math.random() * 0.4, 8, 0.0, -0.3, 0.0, 0.1);
            if (Math.random() > 0.3) {
                ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197631_x, player.func_226277_ct_() - 0.2 + Math.random() * 0.4, player.func_226278_cu_() + Math.random() * 0.2, player.func_226281_cx_() - 0.2 + Math.random() * 0.4, 1, 0.0, -0.3, 0.0, 0.1);
            }
        }
    }

    public static void boostHorizontal(PlayerEntity player) {
        ItemStack itemStack;
        int level;
        if ((player.field_191988_bg != 0.0f || player.field_70702_br != 0.0f) && (level = UtilBooster.getBoosterLevel(itemStack = ToolbeltHelper.findToolbelt(player))) > 0) {
            CastOptional.cast(player, ClientPlayerEntity.class).ifPresent(cp -> cp.field_71174_a.func_147297_a((IPacket)new CInputPacket(cp.field_70702_br, cp.field_191988_bg, cp.field_71158_b.field_78901_c, cp.field_71158_b.field_228350_h_)));
            CompoundNBT tag = itemStack.func_196082_o();
            if (UtilBooster.hasFuel(tag, false)) {
                UtilBooster.consumeFuel(tag, false);
                player.func_213309_a(0.05f, new Vector3d((double)player.field_70702_br, (double)player.field_70701_bs, (double)player.field_191988_bg));
                if (player.field_70170_p.field_72995_K) {
                    Vector3d direction = UtilBooster.getAbsoluteMotion(-player.field_70702_br, -player.field_191988_bg, player.field_70177_z);
                    for (int i = 0; i < 8; ++i) {
                        player.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_213302_cg() * 0.4, player.func_226281_cx_(), Math.random() * (0.2 * direction.field_72450_a + 0.07) - 0.05, Math.random() * 0.1 - 0.05, Math.random() * (0.2 * direction.field_72449_c + 0.07) - 0.05);
                    }
                    if (Math.random() > 0.3) {
                        player.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_213302_cg() * 0.4, player.func_226281_cx_(), Math.random() * (0.2 * direction.field_72450_a + 0.07) - 0.05, Math.random() * 0.1 - 0.05, Math.random() * (0.2 * direction.field_72449_c + 0.07) - 0.05);
                    }
                }
            }
        }
    }

    private static Vector3d getAbsoluteMotion(float strafe, float forward, float facing) {
        float sin = MathHelper.func_76126_a((float)(facing * ((float)Math.PI / 180)));
        float cos = MathHelper.func_76134_b((float)(facing * ((float)Math.PI / 180)));
        return new Vector3d((double)(strafe * cos - forward * sin), 0.0, (double)(forward * cos + strafe * sin));
    }

    public static void boostPlayerCharged(PlayerEntity player, CompoundNBT tag, int level) {
        float boostBase = 1.2f + 1.2f * (float)(level - 1) * 0.4f;
        Vector3d lookVector = player.func_70040_Z();
        player.func_213317_d(lookVector.func_186678_a(player.func_213322_ci().func_72430_b(lookVector) / lookVector.func_72430_b(lookVector)));
        player.func_70024_g(lookVector.field_72450_a * (double)boostBase, Math.max(lookVector.field_72448_b * (double)boostBase / 2.0 + 0.3, 0.1), lookVector.field_72449_c * (double)boostBase);
        player.field_70133_I = true;
        player.func_213315_a(MoverType.SELF, new Vector3d(0.0, 0.4, 0.0));
        if (player.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197594_E, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_213302_cg() * 0.4, player.func_226281_cx_(), 10, 0.0, -0.1, 0.0, 0.1);
            ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197631_x, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_213302_cg() * 0.4, player.func_226281_cx_(), 3, 0.0, -0.1, 0.0, 0.1);
        }
    }

    public static void consumeFuel(CompoundNBT tag, boolean charged) {
        if (charged) {
            tag.func_74768_a(fuelKey, tag.func_74762_e(fuelKey) - 40);
        } else {
            tag.func_74768_a(fuelKey, tag.func_74762_e(fuelKey) - 1);
        }
        tag.func_74768_a(cooldownKey, 20);
    }

    public static void consumeFuel(CompoundNBT tag, int amount) {
        tag.func_74768_a(fuelKey, tag.func_74762_e(fuelKey) - amount);
        tag.func_74768_a(cooldownKey, 20);
    }

    public static void rechargeFuel(CompoundNBT tag, ItemStack itemStack) {
        int fuel = tag.func_74762_e(fuelKey);
        int buffer = tag.func_74762_e(bufferKey);
        int cooldown = tag.func_74762_e(cooldownKey);
        if (cooldown > 0) {
            tag.func_74768_a(cooldownKey, cooldown - 1);
        } else if (fuel + 1 < 110) {
            if (buffer > 0) {
                tag.func_74768_a(fuelKey, fuel + 1);
                tag.func_74768_a(bufferKey, buffer - 1);
            } else {
                UtilBooster.refuelBuffer(tag, itemStack);
            }
        }
    }

    private static void refuelBuffer(CompoundNBT tag, ItemStack itemStack) {
        ToolbeltInventory inventory = new QuickslotInventory(itemStack);
        int index = inventory.getFirstIndexForItem(Items.field_151016_H);
        if (index != -1) {
            inventory.func_70298_a(index, 1);
            tag.func_74768_a(bufferKey, 80);
            return;
        }
        inventory = new StorageInventory(itemStack);
        index = inventory.getFirstIndexForItem(Items.field_151016_H);
        if (index != -1) {
            inventory.func_70298_a(index, 1);
            tag.func_74768_a(bufferKey, 80);
            return;
        }
        tag.func_74768_a(cooldownKey, 20);
    }

    public static boolean isActive(CompoundNBT tag) {
        return tag.func_74767_n(activeKey);
    }

    public static void setActive(CompoundNBT tag, boolean active, boolean charged) {
        tag.func_74757_a(activeKey, active);
        if (charged) {
            tag.func_74757_a(chargedKey, charged);
        }
    }
}

