/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.shield;

import com.google.common.collect.Multimap;
import java.util.Optional;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.BlockProgressOverlay;
import se.mickelus.tetra.items.modular.impl.shield.ApplyBannerSchematic;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldISTER;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.TetraAttributes;
import se.mickelus.tetra.util.CastOptional;

public class ModularShieldItem
extends ItemModularHandheld {
    public static final String plateKey = "shield/plate";
    public static final String gripKey = "shield/grip";
    public static final String bossKey = "shield/boss";
    public static final String unlocalizedName = "modular_shield";
    public static final String bannerImprovementKey = "shield/banner";
    @ObjectHolder(value="tetra:modular_shield")
    public static ModularShieldItem instance;

    public ModularShieldItem() {
        super(new Item.Properties().func_200917_a(1).func_234689_a_().setISTER(() -> ModularShieldISTER::new));
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{plateKey, gripKey};
        this.minorModuleKeys = new String[]{bossKey};
        this.requiredModules = new String[]{plateKey, gripKey};
        this.updateConfig((Integer)ConfigHandler.honeShieldBase.get(), (Integer)ConfigHandler.honeShieldIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this));
        SchematicRegistry.instance.registerSchematic(new ApplyBannerSchematic());
        RemoveSchematic.registerRemoveSchematics(this);
        ItemUpgradeRegistry.instance.registerReplacementHook(this::copyBanner);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("shield/");
        });
    }

    @Override
    public void clientInit() {
        super.clientInit();
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
        MinecraftForge.EVENT_BUS.register((Object)new BlockProgressOverlay(Minecraft.func_71410_x()));
    }

    private ItemStack copyBanner(ItemStack original, ItemStack replacement) {
        if (this.equals(replacement.func_77973_b())) {
            Optional.ofNullable(original.func_179543_a("BlockEntityTag")).ifPresent(tag -> {
                replacement.func_196082_o().func_218657_a("BlockEntityTag", (INBT)tag);
                CastOptional.cast(this.getModuleFromSlot(replacement, plateKey), ItemModuleMajor.class).filter(module -> module.acceptsImprovement(bannerImprovementKey)).ifPresent(module -> module.addImprovement(replacement, bannerImprovementKey, 0));
            });
        }
        return replacement;
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        if (slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        return AttributeHelper.emptyMap;
    }

    @Override
    public double getAbilityBaseDamage(ItemStack itemStack) {
        return this.getAttributeValue(itemStack, (Attribute)TetraAttributes.abilityDamage.get());
    }

    @Override
    public double getCooldownBase(ItemStack itemStack) {
        return this.getAttributeValue(itemStack, (Attribute)TetraAttributes.abilityCooldown.get());
    }
}

