/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiItem;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.mgui.gui.impl.GuiHorizontalLayoutGroup;
import se.mickelus.tetra.blocks.workbench.gui.ToolRequirementGui;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiSynergyIndicator;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloImprovementButton;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloImprovementListGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.OutcomeStack;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.properties.PropertyHelper;

public class HoloVariantDetailGui
extends GuiElement {
    private final GuiHorizontalLayoutGroup header;
    private GuiString variantLabel;
    private GuiSynergyIndicator synergyIndicator;
    private GuiElement requiredTools;
    private GuiItemRolling material;
    private HoloStatsGui stats;
    private Map<ToolType, Integer> availableToolLevels;
    private Runnable populateImprovements;
    private HoloImprovementButton improvementButton;
    private HoloImprovementListGui improvements;
    private KeyframeAnimation openAnimation;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;
    private final KeyframeAnimation foldAnimation;
    private final KeyframeAnimation unfoldAnimation;
    private OutcomePreview variantOutcome;
    private OutcomePreview currentOutcome;
    private String slot;
    private List<OutcomeStack> selectedOutcomes;
    private OutcomePreview hoveredImprovement;
    private int originalY;

    public HoloVariantDetailGui(int x, int y, int width, Consumer<OutcomePreview> onVariantOpen) {
        super(x, y, width, 100);
        this.originalY = y;
        this.selectedOutcomes = new LinkedList<OutcomeStack>();
        this.header = new GuiHorizontalLayoutGroup(0, 0, 20, 5);
        this.addChild((GuiElement)this.header);
        this.variantLabel = new GuiString(0, 0, "");
        this.header.addChild((GuiElement)this.variantLabel);
        this.synergyIndicator = new GuiSynergyIndicator(0, -1, true);
        this.header.addChild((GuiElement)this.synergyIndicator);
        MaterialWrapper materialWrapper = new MaterialWrapper(0, -4);
        this.material = new GuiItemRolling(0, 0).setCountVisibility(GuiItem.CountMode.always);
        materialWrapper.addChild(this.material);
        this.header.addChild((GuiElement)materialWrapper);
        this.requiredTools = new GuiElement(0, -3, width, this.height);
        this.header.addChild(this.requiredTools);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.availableToolLevels = Stream.of(PropertyHelper.getPlayerToolLevels((PlayerEntity)player), PropertyHelper.getToolbeltToolLevels((PlayerEntity)player)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
        this.stats = new HoloStatsGui(-5, 24);
        this.addChild(this.stats);
        this.improvementButton = new HoloImprovementButton(0, 64, () -> onVariantOpen.accept(this.variantOutcome));
        this.improvementButton.setAttachment(GuiAttachment.topCenter);
        this.addChild((GuiElement)this.improvementButton);
        this.improvements = new HoloImprovementListGui(0, 78, width, 0, this::onImprovementHover, this::onImprovementBlur, this::onImprovementSelect);
        this.addChild(this.improvements);
        this.openAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY((float)(y - 4), (float)y)}).withDelay(120);
        this.showAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY((float)y)});
        this.hideAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY((float)(y - 5))}).onStop(complete -> {
            if (complete.booleanValue()) {
                this.isVisible = false;
            }
        });
        this.foldAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateY(0.0f)});
        this.unfoldAnimation = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateY((float)y)});
    }

    public void updateVariant(OutcomePreview selectedOutcome, OutcomePreview hoveredOutcome, String slot) {
        this.variantOutcome = selectedOutcome;
        this.currentOutcome = selectedOutcome;
        this.slot = slot;
        if (selectedOutcome != null || hoveredOutcome != null) {
            OutcomePreview baseOutcome = hoveredOutcome != null ? hoveredOutcome : selectedOutcome;
            this.variantLabel.setString(I18n.func_135052_a((String)ItemModule.getName(baseOutcome.moduleKey, baseOutcome.variantKey), (Object[])new Object[0]));
            this.synergyIndicator.update(baseOutcome.itemStack, slot);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack improvementStack = baseOutcome.itemStack;
            UpgradeSchematic[] improvementSchematics = (UpgradeSchematic[])Arrays.stream(SchematicRegistry.getSchematics(slot, improvementStack)).filter(improvementSchematic -> SchematicType.improvement.equals((Object)improvementSchematic.getType())).filter(improvementSchematic -> improvementSchematic.isApplicableForItem(improvementStack)).filter(arg_0 -> HoloVariantDetailGui.lambda$updateVariant$4((PlayerEntity)player, improvementStack, arg_0)).toArray(UpgradeSchematic[]::new);
            this.improvementButton.updateCount(improvementSchematics.length);
            this.populateImprovements = () -> {
                this.improvements.updateSchematics(improvementStack, slot, improvementSchematics);
                this.populateImprovements = null;
            };
            this.requiredTools.clearChildren();
            baseOutcome.tools.getLevelMap().forEach((tool, level) -> {
                ToolRequirementGui requirement = new ToolRequirementGui(this.requiredTools.getNumChildren() * 20, 0, (ToolType)tool, "tetra.tool." + tool.getName() + ".craft_requirement");
                requirement.updateRequirement((int)level, this.availableToolLevels.getOrDefault(tool, 0));
                this.requiredTools.addChild((GuiElement)requirement);
            });
            this.material.setItems(baseOutcome.materials);
            this.updateStats(selectedOutcome, hoveredOutcome);
            this.header.forceLayout();
            this.show();
        } else {
            this.hide();
        }
    }

    public void onImprovementSelect(OutcomeStack selectedStack) {
        boolean wasRemoved = this.selectedOutcomes.removeIf(stack -> stack.equals(selectedStack));
        if (!wasRemoved) {
            this.selectedOutcomes.add(selectedStack);
        }
        this.currentOutcome = this.variantOutcome.clone();
        block0: for (OutcomeStack stack2 : this.selectedOutcomes) {
            OutcomePreview[] tempPreviews;
            for (OutcomePreview tempPreview : tempPreviews = stack2.schematic.getPreviews(this.currentOutcome.itemStack, this.slot)) {
                if (!tempPreview.equals(stack2.preview)) continue;
                this.currentOutcome = tempPreview;
                continue block0;
            }
        }
        this.selectedOutcomes.removeIf(stack -> !stack.preview.isApplied(this.currentOutcome.itemStack, this.slot));
        this.improvements.updateSelection(this.currentOutcome.itemStack, this.selectedOutcomes);
        this.updateStats(this.currentOutcome, this.currentOutcome);
    }

    private void onImprovementHover(OutcomePreview improvement) {
        this.updateStats(this.currentOutcome, improvement);
        this.hoveredImprovement = improvement;
    }

    private void onImprovementBlur(OutcomePreview improvement) {
        if (improvement.equals(this.hoveredImprovement)) {
            this.updateStats(this.currentOutcome, null);
            this.hoveredImprovement = null;
        }
    }

    public void updateStats(OutcomePreview selectedOutcome, OutcomePreview hoveredOutcome) {
        ItemStack baseStack = hoveredOutcome != null ? hoveredOutcome.itemStack : (selectedOutcome != null ? selectedOutcome.itemStack : ItemStack.field_190927_a);
        this.stats.update(selectedOutcome != null ? selectedOutcome.itemStack : baseStack, baseStack, null, null, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void animateOpen() {
        this.stats.realignBars();
        this.openAnimation.start();
    }

    public void show() {
        this.hideAnimation.stop();
        this.setVisible(true);
        this.showAnimation.start();
    }

    public void hide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
    }

    public void forceHide() {
        this.setY(this.originalY);
        this.setOpacity(0.0f);
        this.improvements.forceHide();
        this.improvementButton.setVisible(false);
    }

    public void showImprovements() {
        if (this.populateImprovements != null) {
            this.populateImprovements.run();
        }
        this.unfoldAnimation.stop();
        this.foldAnimation.start();
        this.improvements.show();
        this.improvementButton.hide();
    }

    public void hideImprovements() {
        this.currentOutcome = this.variantOutcome;
        this.selectedOutcomes.clear();
        if (this.currentOutcome != null) {
            this.updateStats(this.currentOutcome, null);
        }
        this.foldAnimation.stop();
        this.unfoldAnimation.start();
        this.improvements.hide();
        this.improvementButton.show();
    }

    private static /* synthetic */ boolean lambda$updateVariant$4(PlayerEntity player, ItemStack improvementStack, UpgradeSchematic improvementSchematic) {
        return improvementSchematic.isVisibleForPlayer(player, null, improvementStack);
    }

    static class MaterialWrapper
    extends GuiElement {
        public MaterialWrapper(int x, int y) {
            super(x, y, 16, 16);
        }

        public List<String> getTooltipLines() {
            List tooltip;
            if (this.hasFocus() && (tooltip = super.getTooltipLines()) != null && tooltip.size() > 0) {
                return ImmutableList.of((Object)I18n.func_135052_a((String)"tetra.holo.craft.material_requirement", (Object[])new Object[]{tooltip.get(0)}));
            }
            return null;
        }
    }
}

