/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.ClientScheduler;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloGui;
import se.mickelus.tetra.module.schematic.SchematicRarity;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class HoloMaterialApplicable
extends GuiElement {
    private final List<String> emptyTooltip = Collections.singletonList(I18n.func_135052_a((String)"tetra.holo.craft.empty_applicable_materials", (Object[])new Object[0]));
    private List<String> tooltip;
    private GuiTexture icon = new GuiTexture(0, 0, 9, 9, 215, 0, GuiTextures.workbench);
    private IModularItem item;
    private String slot;
    private UpgradeSchematic schematic;

    public HoloMaterialApplicable(int x, int y) {
        super(x, y, 9, 9);
        this.addChild((GuiElement)this.icon);
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return null;
    }

    public void update(ItemStack itemStack, String slot, UpgradeSchematic schematic, PlayerEntity playerEntity) {
        this.item = null;
        this.slot = null;
        this.schematic = null;
        ImmutableList.Builder tooltipBuilder = new ImmutableList.Builder();
        String[] materials = schematic.getApplicableMaterials();
        if (materials != null && materials.length > 0) {
            String materialsString = Arrays.stream(materials).map(mat -> {
                if (mat.startsWith("#")) {
                    return I18n.func_135052_a((String)("tetra.variant_category." + mat.substring(1) + ".label"), (Object[])new Object[0]);
                }
                if (mat.startsWith("!")) {
                    return I18n.func_135052_a((String)("tetra.material." + mat.substring(1)), (Object[])new Object[0]);
                }
                return Optional.ofNullable(ForgeRegistries.ITEMS.getValue(new ResourceLocation(mat))).map(Item::func_200296_o).map(ITextComponent::getString).orElse((String)mat);
            }).collect(Collectors.joining(", "));
            tooltipBuilder.add((Object[])new String[]{I18n.func_135052_a((String)"tetra.holo.craft.applicable_materials", (Object[])new Object[0]), TextFormatting.GRAY + materialsString});
            tooltipBuilder.add((Object)" ");
            if (schematic.getType() != SchematicType.major && schematic.getType() != SchematicType.minor || schematic.getRarity() != SchematicRarity.basic) {
                tooltipBuilder.add((Object)I18n.func_135052_a((String)"tetra.holo.craft.holosphere_shortcut_disabled", (Object[])new Object[0]));
                tooltipBuilder.add((Object)(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"tetra.holo.craft.holosphere_shortcut_unavailable", (Object[])new Object[0])));
            } else if (ModularHolosphereItem.findHolosphere(playerEntity).func_190926_b() || !(itemStack.func_77973_b() instanceof IModularItem)) {
                tooltipBuilder.add((Object)I18n.func_135052_a((String)"tetra.holo.craft.holosphere_shortcut_disabled", (Object[])new Object[0]));
                tooltipBuilder.add((Object)(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"tetra.holo.craft.holosphere_shortcut_missing", (Object[])new Object[0])));
            } else {
                tooltipBuilder.add((Object)I18n.func_135052_a((String)"tetra.holo.craft.holosphere_shortcut", (Object[])new Object[0]));
                this.item = (IModularItem)itemStack.func_77973_b();
                this.slot = slot;
                this.schematic = schematic;
            }
            this.tooltip = tooltipBuilder.build();
        } else {
            this.tooltip = this.emptyTooltip;
        }
    }

    public boolean onMouseClick(int x, int y, int button) {
        if (this.hasFocus() && this.item != null) {
            Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
            HoloGui gui = HoloGui.getInstance();
            Minecraft.func_71410_x().func_147108_a((Screen)gui);
            gui.openSchematic(this.item, this.slot, this.schematic, () -> ClientScheduler.schedule(0, () -> Minecraft.func_71410_x().func_147108_a(currentScreen)));
            return true;
        }
        return false;
    }
}

