/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiStringOutline;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.GuiAnimation;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSlotGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSlotMajorGui;

public class HoloItemGui
extends GuiClickable {
    GuiElement slotGroup;
    private List<GuiAnimation> selectAnimations = new ArrayList<GuiAnimation>();
    private List<GuiAnimation> deselectAnimations = new ArrayList<GuiAnimation>();
    private List<GuiAnimation> hoverAnimations = new ArrayList<GuiAnimation>();
    private List<GuiAnimation> blurAnimations = new ArrayList<GuiAnimation>();
    private KeyframeAnimation itemShow;
    private KeyframeAnimation itemHide;
    private boolean isSelected = false;
    private final GuiTexture backdrop = new GuiTexture(0, 0, 52, 52, GuiTextures.workbench);
    private final GuiTexture icon;
    private IModularItem item;

    public HoloItemGui(int x, int y, IModularItem item, int textureIndex, Runnable onSelect, Consumer<String> onSlotSelect) {
        super(x, y, 64, 64, onSelect);
        this.backdrop.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.backdrop);
        this.icon = new GuiTexture(0, 0, 38, 38, 38 * (textureIndex % 6), 218 - 38 * (textureIndex / 6), GuiTextures.workbench);
        this.icon.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.icon);
        GuiElement labelGroup = new GuiElement(0, 0, 0, 0);
        String[] labelStrings = I18n.func_135052_a((String)("tetra.holo.craft." + item.getItem().getRegistryName().func_110623_a()), (Object[])new Object[0]).split(" ");
        for (int i = 0; i < labelStrings.length; ++i) {
            GuiStringOutline labelLine = new GuiStringOutline(0, i * 10, labelStrings[i]);
            labelLine.setAttachment(GuiAttachment.topCenter);
            labelLine.setColor(0xFFFFCC);
            labelGroup.addChild((GuiElement)labelLine);
        }
        labelGroup.setAttachment(GuiAttachment.middleCenter);
        labelGroup.setHeight(10 * labelStrings.length);
        labelGroup.setOpacity(0.0f);
        this.addChild(labelGroup);
        this.slotGroup = new GuiElement(37, 15, 0, 0);
        this.setupSlots(item, onSlotSelect);
        this.slotGroup.setVisible(false);
        this.addChild(this.slotGroup);
        this.selectAnimations.add((GuiAnimation)new KeyframeAnimation(80, this.slotGroup).applyTo(new Applier[]{new Applier.Opacity(1.0f)}));
        this.deselectAnimations.add((GuiAnimation)new KeyframeAnimation(80, this.slotGroup).applyTo(new Applier[]{new Applier.Opacity(0.0f)}).onStop(complete -> {
            if (complete.booleanValue()) {
                this.slotGroup.setVisible(false);
            }
        }));
        this.selectAnimations.add((GuiAnimation)new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX(0.0f), new Applier.TranslateY(0.0f)}));
        this.deselectAnimations.add((GuiAnimation)new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX((float)x), new Applier.TranslateY((float)y)}));
        this.itemShow = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f)});
        this.itemHide = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f)}).onStop(complete -> {
            this.isVisible = false;
        });
        this.hoverAnimations.add((GuiAnimation)new KeyframeAnimation(80, labelGroup).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY(-2.0f, 0.0f)}));
        this.blurAnimations.add((GuiAnimation)new KeyframeAnimation(120, labelGroup).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY(0.0f, 2.0f)}));
        this.item = item;
    }

    public boolean onMouseClick(int x, int y, int button) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (!((GuiElement)this.elements.get(i)).isVisible() || !((GuiElement)this.elements.get(i)).onMouseClick(x, y, button)) continue;
            return true;
        }
        return super.onMouseClick(x, y, button);
    }

    public void onItemSelected(IModularItem item) {
        if (this.item.equals(item)) {
            this.setVisible(true);
            this.setSelected(true);
        } else if (item == null) {
            this.setVisible(true);
            this.setSelected(false);
        } else {
            this.setVisible(false);
            this.setSelected(false);
        }
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.deselectAnimations.forEach(GuiAnimation::stop);
            this.slotGroup.setVisible(true);
            this.selectAnimations.forEach(GuiAnimation::start);
            this.icon.setColor(0xFFFFFF);
            this.hoverAnimations.forEach(GuiAnimation::stop);
            this.blurAnimations.forEach(GuiAnimation::start);
        } else {
            this.selectAnimations.forEach(GuiAnimation::stop);
            this.deselectAnimations.forEach(GuiAnimation::start);
        }
        this.backdrop.setColor(0xFFFFFF);
        this.isSelected = selected;
    }

    protected void onShow() {
        super.onShow();
        this.itemHide.stop();
        this.itemShow.start();
    }

    protected boolean onHide() {
        super.onHide();
        this.itemShow.stop();
        this.itemHide.start();
        return false;
    }

    protected void calculateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus = true;
        if ((mouseX -= refX + this.x) + (mouseY -= refY + this.y) < 44) {
            gainFocus = false;
        }
        if (mouseX + mouseY > 84) {
            gainFocus = false;
        }
        if (mouseX - mouseY > 16) {
            gainFocus = false;
        }
        if (mouseY - mouseX > 19) {
            gainFocus = false;
        }
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }

    protected void onFocus() {
        if (!this.isSelected) {
            this.backdrop.setColor(0xFFFFCC);
            this.icon.setColor(0x7F7F7F);
            this.blurAnimations.forEach(GuiAnimation::stop);
            this.hoverAnimations.forEach(GuiAnimation::start);
        }
    }

    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
        this.icon.setColor(0xFFFFFF);
        this.hoverAnimations.forEach(GuiAnimation::stop);
        this.blurAnimations.forEach(GuiAnimation::start);
    }

    private void setupSlots(IModularItem item, Consumer<String> onSlotSelect) {
        GuiAttachment attachment;
        int x;
        int i;
        String[] majorModuleNames = item.getMajorModuleNames();
        String[] majorModuleKeys = item.getMajorModuleKeys();
        GuiModuleOffsets majorOffsets = item.getMajorGuiOffsets();
        String[] minorModuleNames = item.getMinorModuleNames();
        String[] minorModuleKeys = item.getMinorModuleKeys();
        GuiModuleOffsets minorOffsets = item.getMinorGuiOffsets();
        for (i = 0; i < majorModuleNames.length; ++i) {
            x = majorOffsets.getX(i);
            attachment = x > 0 ? GuiAttachment.topLeft : GuiAttachment.topRight;
            this.slotGroup.addChild((GuiElement)new HoloSlotMajorGui(x, majorOffsets.getY(i), attachment, majorModuleKeys[i], majorModuleNames[i], onSlotSelect));
        }
        for (i = 0; i < minorModuleNames.length; ++i) {
            x = minorOffsets.getX(i);
            attachment = x > 0 ? GuiAttachment.topLeft : GuiAttachment.topRight;
            this.slotGroup.addChild((GuiElement)new HoloSlotGui(x, minorOffsets.getY(i), attachment, minorModuleKeys[i], minorModuleNames[i], onSlotSelect));
        }
    }
}

