/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.network.BlockPosPacket;

public class ChargedAbilityPacket
extends BlockPosPacket {
    private int targetId = -1;
    private Hand hand;
    private int ticksUsed;
    private Vector3d hitVec;

    public ChargedAbilityPacket() {
    }

    public ChargedAbilityPacket(LivingEntity target, BlockPos pos, Vector3d hitVec, Hand hand, int ticksUsed) {
        super(pos == null ? BlockPos.field_177992_a : pos);
        this.targetId = Optional.ofNullable(target).map(Entity::func_145782_y).orElse(-1);
        this.hand = hand;
        this.ticksUsed = ticksUsed;
        this.hitVec = hitVec == null ? Vector3d.field_186680_a : hitVec;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.targetId);
        buffer.writeInt(this.hand.ordinal());
        buffer.writeInt(this.ticksUsed);
        buffer.writeDouble(this.hitVec.field_72450_a);
        buffer.writeDouble(this.hitVec.field_72448_b);
        buffer.writeDouble(this.hitVec.field_72449_c);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        super.fromBytes(buffer);
        this.targetId = buffer.readInt();
        this.hand = Hand.values()[buffer.readInt()];
        this.ticksUsed = buffer.readInt();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.hitVec = new Vector3d(x, y, z);
    }

    @Override
    public void handle(PlayerEntity player) {
        LivingEntity target = Optional.of(this.targetId).filter(id -> id != -1).map(id -> player.field_70170_p.func_73045_a(id.intValue())).filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).orElse(null);
        ItemModularHandheld.handleChargedAbility(player, this.hand, target, BlockPos.field_177992_a.equals((Object)this.pos) ? null : this.pos, Vector3d.field_186680_a.equals((Object)this.hitVec) ? null : this.hitVec, this.ticksUsed);
    }
}

