/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.RotationHelper;

public class StrikingEffect {
    private static final Cache<UUID, Integer> strikeCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final BlockPos[] sweep1 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(-3, 0, -1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(3, 0, -1), new BlockPos(-3, 0, -2), new BlockPos(-2, 0, -2), new BlockPos(-1, 0, -2), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(-2, 1, -1), new BlockPos(-1, 1, -1), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(-2, -1, -1), new BlockPos(-1, -1, -1)};
    private static final BlockPos[] sweep2 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(3, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(2, 0, 1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(4, 0, -1), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(1, 1, 0), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(1, -1, 0)};

    public static boolean causeEffect(PlayerEntity breakingPlayer, ItemStack itemStack, ItemModularHandheld item, World world, BlockPos pos, BlockState blockState) {
        int strikingLevel = 0;
        ToolType tool = null;
        if (ItemModularHandheld.isToolEffective(ToolType.AXE, blockState) && (strikingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.strikingAxe)) > 0) {
            tool = ToolType.AXE;
        }
        if (strikingLevel <= 0 && ItemModularHandheld.isToolEffective(ToolType.PICKAXE, blockState) && (strikingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.strikingPickaxe)) > 0) {
            tool = ToolType.PICKAXE;
        }
        if (strikingLevel <= 0 && ItemModularHandheld.isToolEffective(ToolTypes.cut, blockState) && (strikingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.strikingCut)) > 0) {
            tool = ToolTypes.cut;
        }
        if (strikingLevel <= 0 && ItemModularHandheld.isToolEffective(ToolType.SHOVEL, blockState) && (strikingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.strikingShovel)) > 0) {
            tool = ToolType.SHOVEL;
        }
        if (strikingLevel <= 0 && ItemModularHandheld.isToolEffective(ToolType.HOE, blockState) && (strikingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.strikingHoe)) > 0) {
            tool = ToolType.HOE;
        }
        if (strikingLevel > 0) {
            int sweepingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.sweepingStrike);
            if ((double)breakingPlayer.func_184825_o(0.0f) > 0.9 && blockState.func_185887_b((IBlockReader)world, pos) != -1.0f) {
                if (sweepingLevel > 0) {
                    StrikingEffect.breakBlocksAround(world, breakingPlayer, itemStack, pos, tool, sweepingLevel);
                } else {
                    int toolLevel = itemStack.func_77973_b().getHarvestLevel(itemStack, tool, breakingPlayer, blockState);
                    if (toolLevel >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || itemStack.func_150998_b(blockState)) {
                        EffectHelper.breakBlock(world, breakingPlayer, itemStack, pos, blockState, true);
                    }
                }
                item.applyUsageEffects((LivingEntity)breakingPlayer, itemStack, 1.0);
                item.applyDamage(item.getBlockDestroyDamage(), itemStack, (LivingEntity)breakingPlayer);
            }
            breakingPlayer.func_184821_cY();
            return true;
        }
        return false;
    }

    private static int getStrikeCounter(UUID entityId) {
        int counter = 0;
        try {
            counter = (Integer)strikeCache.get((Object)entityId, () -> 0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        strikeCache.put((Object)entityId, (Object)(counter + 1));
        return counter;
    }

    private static void breakBlocksAround(World world, PlayerEntity breakingPlayer, ItemStack toolStack, BlockPos originPos, ToolType tool, int sweepingLevel) {
        if (world.field_72995_K) {
            return;
        }
        Direction facing = breakingPlayer.func_174811_aO();
        int strikeCounter = StrikingEffect.getStrikeCounter(breakingPlayer.func_110124_au());
        boolean alternate = strikeCounter % 2 == 0;
        double efficiency = CastOptional.cast(toolStack.func_77973_b(), ItemModularHandheld.class).map(item -> Float.valueOf(item.getToolEfficiency(toolStack, tool))).orElse(Float.valueOf(0.0f)).floatValue();
        double critMultiplier = CastOptional.cast(toolStack.func_77973_b(), ItemModularHandheld.class).map(item -> CritEffect.rollMultiplier(breakingPlayer.func_70681_au(), item, toolStack)).orElse(1.0);
        if (critMultiplier != 1.0) {
            efficiency *= critMultiplier;
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197622_o, (double)((float)originPos.func_177958_n() + 0.5f), (double)((float)originPos.func_177956_o() + 0.5f), (double)((float)originPos.func_177952_p() + 0.5f), 15, 0.2, 0.2, 0.2, 0.0);
        }
        breakingPlayer.func_184810_cG();
        int[] delays = Arrays.stream(strikeCounter / 2 % 2 == 0 ? sweep1 : sweep2).map(Vector3i::func_177958_n).mapToInt(x -> x + 3).toArray();
        List positions = Arrays.stream(strikeCounter / 2 % 2 == 0 ? sweep1 : sweep2).map(pos -> alternate ? new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) : pos).map(pos -> RotationHelper.rotatePitch(pos, breakingPlayer.field_70125_A)).map(pos -> RotationHelper.rotateDirection(pos, facing)).map(arg_0 -> ((BlockPos)originPos).func_177971_a(arg_0)).collect(Collectors.toList());
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos pos2 = (BlockPos)positions.get(i);
            BlockState blockState = world.func_180495_p(pos2);
            float blockHardness = blockState.func_185887_b((IBlockReader)world, pos2);
            if (ItemModularHandheld.isToolEffective(tool, blockState) && blockHardness != -1.0f) {
                int toolLevel = toolStack.func_77973_b().getHarvestLevel(toolStack, tool, breakingPlayer, blockState);
                if ((toolLevel < 0 || toolLevel < blockState.func_177230_c().getHarvestLevel(blockState)) && !toolStack.func_150998_b(blockState)) break;
                efficiency -= (double)blockHardness + 0.5;
                StrikingEffect.enqueueBlockBreak(world, breakingPlayer, toolStack, pos2, blockState, tool, toolLevel, delays[i]);
            } else if (blockState.func_200132_m()) {
                efficiency -= (double)Math.abs(blockHardness);
            }
            if (efficiency <= 0.0) break;
        }
    }

    private static void enqueueBlockBreak(World world, PlayerEntity player, ItemStack itemStack, BlockPos pos, BlockState blockState, ToolType tool, int toolLevel, int delay) {
        ServerScheduler.schedule(delay, () -> {
            if ((toolLevel >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || itemStack.func_150998_b(blockState)) && ItemModularHandheld.isToolEffective(tool, blockState) && EffectHelper.breakBlock(world, player, itemStack, pos, blockState, true)) {
                EffectHelper.sendEventToPlayer((ServerPlayerEntity)player, 2001, pos, Block.func_196246_j((BlockState)blockState));
            }
        });
    }
}

