/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.RotationHelper;

public class ExtractorEffect {
    public static void breakBlocks(ItemModularHandheld item, ItemStack itemStack, int effectLevel, ServerWorld world, BlockState state, BlockPos pos, LivingEntity entity) {
        PlayerEntity player = CastOptional.cast(entity, PlayerEntity.class).orElse(null);
        if (effectLevel > 0) {
            Vector3d entityPosition = entity.func_174824_e(0.0f);
            double lookDistance = Optional.ofNullable(entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())).map(ModifiableAttributeInstance::func_111126_e).orElse(5.0);
            Vector3d lookingPosition = entity.func_70040_Z().func_186678_a(lookDistance).func_178787_e(entityPosition);
            BlockRayTraceResult rayTrace = world.func_217299_a(new RayTraceContext(entityPosition, lookingPosition, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
            Direction direction = rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK ? rayTrace.func_216354_b().func_176734_d() : Direction.func_196054_a((Entity)entity)[0];
            float refHardness = state.func_185887_b((IBlockReader)world, pos);
            ToolType refTool = ItemModularHandheld.getEffectiveTool(state);
            double critMultiplier = CritEffect.rollMultiplier(entity.func_70681_au(), item, itemStack);
            if (critMultiplier != 1.0) {
                effectLevel = (int)((double)effectLevel * critMultiplier);
                world.func_195598_a((IParticleData)ParticleTypes.field_197622_o, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 15, 0.2, 0.2, 0.2, 0.0);
            }
            if (refTool != null && item.getToolLevel(itemStack, refTool) > 0) {
                ExtractorEffect.breakRecursive((World)world, player, item, itemStack, direction, pos, refHardness, refTool, effectLevel);
                item.applyDamage(effectLevel, itemStack, entity);
                item.tickProgression(entity, itemStack, MathHelper.func_76143_f((double)((double)effectLevel / 2.0)));
            }
        }
    }

    private static void breakRecursive(World world, PlayerEntity player, ItemModularHandheld item, ItemStack itemStack, Direction direction, BlockPos pos, float refHardness, ToolType refTool, int remaining) {
        if (remaining > 0) {
            ServerScheduler.schedule(2, () -> ExtractorEffect.breakInner(world, player, item, itemStack, direction, pos, refHardness, refTool));
        }
        if (remaining > 1) {
            ServerScheduler.schedule(4, () -> ExtractorEffect.breakOuter(world, player, item, itemStack, direction, pos, refHardness, refTool));
        }
        if (remaining > 2) {
            ServerScheduler.schedule(6, () -> {
                BlockPos offsetPos = pos.func_177972_a(direction);
                if (ExtractorEffect.breakBlock(world, player, item, itemStack, offsetPos, refHardness, refTool)) {
                    ExtractorEffect.breakRecursive(world, player, item, itemStack, direction, offsetPos, refHardness, refTool, remaining - 2);
                }
            });
        }
    }

    private static void breakInner(World world, PlayerEntity player, ItemModularHandheld item, ItemStack itemStack, Direction direction, BlockPos pos, float refHardness, ToolType refTool) {
        Vector3i axis1 = RotationHelper.shiftAxis(direction.func_176730_m());
        Vector3i axis2 = RotationHelper.shiftAxis(axis1);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177971_a(axis1), refHardness, refTool);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177973_b(axis1), refHardness, refTool);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177971_a(axis2), refHardness, refTool);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177973_b(axis2), refHardness, refTool);
    }

    private static void breakOuter(World world, PlayerEntity player, ItemModularHandheld item, ItemStack itemStack, Direction direction, BlockPos pos, float refHardness, ToolType refTool) {
        Vector3i axis1 = RotationHelper.shiftAxis(direction.func_176730_m());
        Vector3i axis2 = RotationHelper.shiftAxis(axis1);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177971_a(axis1).func_177971_a(axis2), refHardness, refTool);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177973_b(axis1).func_177973_b(axis2), refHardness, refTool);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177971_a(axis1).func_177973_b(axis2), refHardness, refTool);
        ExtractorEffect.breakBlock(world, player, item, itemStack, pos.func_177973_b(axis1).func_177971_a(axis2), refHardness, refTool);
    }

    private static boolean breakBlock(World world, PlayerEntity player, ItemModularHandheld item, ItemStack itemStack, BlockPos pos, float refHardness, ToolType refTool) {
        BlockState offsetState = world.func_180495_p(pos);
        ToolType effectiveTool = ItemModularHandheld.getEffectiveTool(offsetState);
        float blockHardness = offsetState.func_185887_b((IBlockReader)world, pos);
        int toolLevel = itemStack.func_77973_b().getHarvestLevel(itemStack, effectiveTool, player, offsetState);
        if ((toolLevel >= 0 && toolLevel >= offsetState.func_177230_c().getHarvestLevel(offsetState) || itemStack.func_150998_b(offsetState)) && blockHardness != -1.0f && blockHardness <= refHardness && ItemModularHandheld.isToolEffective(refTool, offsetState) && EffectHelper.breakBlock(world, player, itemStack, pos, offsetState, true)) {
            EffectHelper.sendEventToPlayer((ServerPlayerEntity)player, 2001, pos, Block.func_196246_j((BlockState)offsetState));
            item.applyBreakEffects(itemStack, world, offsetState, pos, (LivingEntity)player);
            return true;
        }
        return false;
    }
}

