/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.Environment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.data.UpdateDataPacket;

public class DataStore<V>
extends ReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger logger = LogManager.getLogger();
    protected static final int jsonExtLength = ".json".length();
    protected Gson gson;
    protected String directory;
    protected Class<V> dataClass;
    protected Map<ResourceLocation, JsonElement> rawData;
    protected Map<ResourceLocation, V> dataMap;
    protected List<Runnable> listeners;

    public DataStore(Gson gson, String directory, Class<V> dataClass) {
        this.gson = gson;
        this.directory = directory;
        this.dataClass = dataClass;
        this.rawData = Collections.emptyMap();
        this.dataMap = Collections.emptyMap();
        this.listeners = new LinkedList<Runnable>();
    }

    protected Map<ResourceLocation, JsonElement> prepare(IResourceManager resourceManager, IProfiler profiler) {
        logger.debug("Reading data for {} data store...", (Object)this.directory);
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (ResourceLocation fullLocation : resourceManager.func_199003_a(this.directory, rl -> rl.endsWith(".json"))) {
            if (!"tetra".equals(fullLocation.func_110624_b())) continue;
            String path = fullLocation.func_110623_a();
            ResourceLocation location = new ResourceLocation(fullLocation.func_110624_b(), path.substring(i, path.length() - jsonExtLength));
            try {
                IResource resource = resourceManager.func_199002_a(fullLocation);
                Throwable throwable = null;
                try {
                    InputStream inputStream = resource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            JsonElement json = this.dataClass.isArray() ? (JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonArray.class) : (JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonElement.class);
                            if (json != null) {
                                if (this.shouldLoad(json)) {
                                    JsonElement duplicate = map.put(location, json);
                                    if (duplicate == null) continue;
                                    throw new IllegalStateException("Duplicate data ignored with ID " + location);
                                }
                                logger.debug("Skipping data '{}' due to condition", (Object)fullLocation);
                                continue;
                            }
                            logger.error("Couldn't load data from '{}' as it's null or empty", (Object)fullLocation);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                logger.error("Couldn't parse data '{}' from '{}'", (Object)location, (Object)fullLocation, (Object)jsonparseexception);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManager, IProfiler profiler) {
        this.rawData = splashList;
        if (Environment.get().getDist().isDedicatedServer() && ServerLifecycleHooks.getCurrentServer() != null) {
            TetraMod.packetHandler.sendToAllPlayers(new UpdateDataPacket(this.directory, this.rawData));
        }
        this.parseData(this.rawData);
    }

    public void sendToPlayer(ServerPlayerEntity player) {
        TetraMod.packetHandler.sendTo(new UpdateDataPacket(this.directory, this.rawData), player);
    }

    public void loadFromPacket(Map<ResourceLocation, String> data) {
        Map<ResourceLocation, JsonElement> splashList = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (this.dataClass.isArray()) {
                return (JsonElement)JSONUtils.func_188178_a((Gson)this.gson, (String)((String)entry.getValue()), JsonArray.class);
            }
            return (JsonElement)JSONUtils.func_188178_a((Gson)this.gson, (String)((String)entry.getValue()), JsonElement.class);
        }));
        this.parseData(splashList);
    }

    public void parseData(Map<ResourceLocation, JsonElement> splashList) {
        logger.info("Loaded {} {}", (Object)String.format("%3d", splashList.values().size()), (Object)this.directory);
        this.dataMap = splashList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.gson.fromJson((JsonElement)entry.getValue(), this.dataClass)));
        this.processData();
        this.listeners.forEach(Runnable::run);
    }

    protected boolean shouldLoad(JsonElement json) {
        JsonArray arr;
        if (json.isJsonArray() && (arr = json.getAsJsonArray()).size() > 0) {
            json = arr.get(0);
        }
        if (!json.isJsonObject()) {
            return true;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        return !jsonObject.has("conditions") || CraftingHelper.processConditions((JsonArray)JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"conditions"));
    }

    protected void processData() {
    }

    public Map<ResourceLocation, JsonElement> getRawData() {
        return this.rawData;
    }

    public String getDirectory() {
        return this.directory;
    }

    public V getData(ResourceLocation resourceLocation) {
        return this.dataMap.get(resourceLocation);
    }

    public Map<ResourceLocation, V> getData() {
        return this.dataMap;
    }

    public Collection<V> getDataIn(ResourceLocation resourceLocation) {
        return this.getData().entrySet().stream().filter(entry -> resourceLocation.func_110624_b().equals(((ResourceLocation)entry.getKey()).func_110624_b()) && ((ResourceLocation)entry.getKey()).func_110623_a().startsWith(resourceLocation.func_110623_a())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void onReload(Runnable callback) {
        this.listeners.add(callback);
    }
}

