/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiButton;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.tetra.blocks.workbench.gui.GuiTweakSlider;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.TweakData;

public class GuiTweakControls
extends GuiElement {
    private GuiString untweakableLabel = new GuiString(0, -3, TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"tetra.workbench.module_detail.not_tweakable", (Object[])new Object[0]));
    private GuiElement tweakControls;
    private GuiButton applyButton;
    private Consumer<Map<String, Integer>> previewTweak;
    private Map<String, Integer> tweaks;

    public GuiTweakControls(int x, int y, Consumer<Map<String, Integer>> previewTweak, Consumer<Map<String, Integer>> applyTweak) {
        super(x, y, 224, 67);
        this.untweakableLabel.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.untweakableLabel);
        this.tweakControls = new GuiElement(0, -4, this.width, this.height - 20);
        this.tweakControls.setAttachment(GuiAttachment.middleLeft);
        this.addChild(this.tweakControls);
        this.applyButton = new GuiButton(0, -10, I18n.func_135052_a((String)"tetra.workbench.slot_detail.tweak_apply", (Object[])new Object[0]), () -> applyTweak.accept(this.tweaks));
        this.applyButton.setAttachment(GuiAttachment.bottomCenter);
        this.addChild((GuiElement)this.applyButton);
        this.previewTweak = previewTweak;
        this.tweaks = new HashMap<String, Integer>();
    }

    public void update(ItemModule module, ItemStack itemStack) {
        this.tweakControls.clearChildren();
        if (module != null && module.isTweakable(itemStack)) {
            TweakData[] data = module.getTweaks(itemStack);
            this.tweakControls.setHeight(data.length * 22);
            for (int i = 0; i < data.length; ++i) {
                TweakData tweak = data[i];
                GuiTweakSlider slider = new GuiTweakSlider(0, i * 22, 200, tweak, step -> this.applyTweak(tweak.key, (int)step));
                slider.setAttachment(GuiAttachment.topCenter);
                slider.setValue(module.getTweakStep(itemStack, tweak));
                this.tweakControls.addChild((GuiElement)slider);
            }
            this.applyButton.setVisible(true);
            this.untweakableLabel.setVisible(false);
        } else {
            this.applyButton.setVisible(false);
            this.untweakableLabel.setVisible(true);
        }
    }

    private void applyTweak(String key, int step) {
        this.tweaks.put(key, step);
        this.previewTweak.accept(this.tweaks);
    }
}

