/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.ActionInteraction;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketCraft;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketTweak;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketUpdate;
import se.mickelus.tetra.blocks.workbench.action.ConfigAction;
import se.mickelus.tetra.blocks.workbench.action.RepairAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchActionPacket;
import se.mickelus.tetra.craftingeffect.CraftingEffectRegistry;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.properties.PropertyHelper;
import se.mickelus.tetra.util.CastOptional;

public class WorkbenchTile
extends TileEntity
implements INamedContainerProvider {
    public static final String unlocalizedName = "workbench";
    @ObjectHolder(value="tetra:workbench")
    public static TileEntityType<WorkbenchTile> type;
    @ObjectHolder(value="tetra:workbench")
    public static ContainerType<WorkbenchContainer> containerType;
    private static final String inventoryKey = "inv";
    private static final String currentSlotKey = "current_slot";
    private static final String schematicKey = "schematic";
    public static final int inventorySlots = 4;
    private ItemStack previousTarget = ItemStack.field_190927_a;
    private UpgradeSchematic currentSchematic;
    private String currentSlot;
    private Map<String, Runnable> changeListeners;
    private LazyOptional<ItemStackHandler> handler = LazyOptional.of(this::createHandler);
    private static WorkbenchAction[] defaultActions;
    private static WorkbenchAction[] actions;
    private ActionInteraction interaction;

    public WorkbenchTile() {
        super(type);
        this.changeListeners = new HashMap<String, Runnable>();
    }

    public static void init(PacketHandler packetHandler) {
        packetHandler.registerPacket(WorkbenchPacketUpdate.class, WorkbenchPacketUpdate::new);
        packetHandler.registerPacket(WorkbenchPacketCraft.class, WorkbenchPacketCraft::new);
        packetHandler.registerPacket(WorkbenchActionPacket.class, WorkbenchActionPacket::new);
        packetHandler.registerPacket(WorkbenchPacketTweak.class, WorkbenchPacketTweak::new);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (slot == 0 && (itemStack.func_190926_b() || !ItemStack.func_77989_b((ItemStack)WorkbenchTile.this.getTargetItemStack(), (ItemStack)itemStack))) {
                    WorkbenchTile.this.currentSchematic = null;
                    WorkbenchTile.this.currentSlot = null;
                    WorkbenchTile.this.emptyMaterialSlots();
                }
                if (slot == 0) {
                    WorkbenchTile.this.interaction = ActionInteraction.create(WorkbenchTile.this);
                }
                WorkbenchTile.this.func_70296_d();
                WorkbenchTile.this.field_145850_b.func_184138_a(WorkbenchTile.this.field_174879_c, WorkbenchTile.this.func_195044_w(), WorkbenchTile.this.func_195044_w(), 3);
            }

            public int getSlots() {
                if (WorkbenchTile.this.currentSchematic != null) {
                    return WorkbenchTile.this.currentSchematic.getNumMaterialSlots() + 1;
                }
                return 1;
            }
        };
    }

    public WorkbenchAction[] getAvailableActions(PlayerEntity player) {
        ItemStack itemStack = this.getTargetItemStack();
        return (WorkbenchAction[])Arrays.stream(actions).filter(action -> action.canPerformOn(player, this, itemStack)).toArray(WorkbenchAction[]::new);
    }

    public void performAction(PlayerEntity player, String actionKey) {
        if (this.field_145850_b.field_72995_K) {
            TetraMod.packetHandler.sendToServer(new WorkbenchActionPacket(this.field_174879_c, actionKey));
            return;
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        ItemStack targetStack = this.getTargetItemStack();
        Arrays.stream(actions).filter(action -> action.getKey().equals(actionKey)).findFirst().filter(action -> action.canPerformOn(player, this, targetStack)).filter(action -> this.checkActionTools(player, (WorkbenchAction)action, targetStack)).ifPresent(action -> {
            action.getRequiredTools(targetStack).forEach((requiredTool, requiredLevel) -> {
                ItemStack providingStack = PropertyHelper.getPlayerProvidingItemStack(requiredTool, requiredLevel, (Entity)player);
                if (!providingStack.func_190926_b()) {
                    if (providingStack.func_77973_b() instanceof IToolProvider) {
                        ((IToolProvider)providingStack.func_77973_b()).onActionConsume(providingStack, targetStack, player, (ToolType)requiredTool, (int)requiredLevel, true);
                    }
                } else {
                    ItemStack toolbeltResult = PropertyHelper.consumeActionToolToolbelt(player, targetStack, requiredTool, requiredLevel, true);
                    if (toolbeltResult == null) {
                        CastOptional.cast(this.func_195044_w().func_177230_c(), AbstractWorkbenchBlock.class).ifPresent(block -> block.onActionConsumeTool(this.field_145850_b, this.func_174877_v(), blockState, targetStack, player, (ToolType)requiredTool, (int)requiredLevel, true));
                    }
                }
            });
            action.perform(player, targetStack, this);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        });
    }

    public void performAction(String actionKey) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        ItemStack targetStack = this.getTargetItemStack();
        Arrays.stream(actions).filter(action -> action.getKey().equals(actionKey)).findFirst().filter(action -> action.canPerformOn(null, this, targetStack)).filter(action -> this.checkActionTools((WorkbenchAction)action, targetStack)).ifPresent(action -> {
            action.getRequiredTools(targetStack).forEach((requiredTool, requiredLevel) -> CastOptional.cast(this.func_195044_w().func_177230_c(), AbstractWorkbenchBlock.class).ifPresent(block -> block.onActionConsumeTool(this.field_145850_b, this.func_174877_v(), blockState, targetStack, null, (ToolType)requiredTool, (int)requiredLevel, true)));
            action.perform(null, targetStack, this);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        });
    }

    private boolean checkActionTools(PlayerEntity player, WorkbenchAction action, ItemStack itemStack) {
        return action.getRequiredTools(itemStack).entrySet().stream().allMatch(requirement -> PropertyHelper.getCombinedToolLevel(player, this.func_145831_w(), this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), (ToolType)requirement.getKey()) >= (Integer)requirement.getValue());
    }

    private boolean checkActionTools(WorkbenchAction action, ItemStack itemStack) {
        return action.getRequiredTools(itemStack).entrySet().stream().allMatch(requirement -> PropertyHelper.getBlockToolLevel(this.func_145831_w(), this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), (ToolType)requirement.getKey()) >= (Integer)requirement.getValue());
    }

    public BlockInteraction[] getInteractions() {
        if (this.interaction != null) {
            return new BlockInteraction[]{this.interaction};
        }
        return new BlockInteraction[0];
    }

    public UpgradeSchematic getCurrentSchematic() {
        return this.currentSchematic;
    }

    public void setCurrentSchematic(UpgradeSchematic schematic, String currentSlot) {
        this.currentSchematic = schematic;
        this.currentSlot = currentSlot;
        this.changeListeners.values().forEach(Runnable::run);
        this.sync();
    }

    public void clearSchematic() {
        this.setCurrentSchematic(null, null);
    }

    public void update(UpgradeSchematic currentSchematic, String currentSlot, PlayerEntity player) {
        if (currentSchematic == null && player != null) {
            this.emptyMaterialSlots(player);
        }
        this.currentSchematic = currentSchematic;
        this.currentSlot = currentSlot;
        this.sync();
    }

    public String getCurrentSlot() {
        return this.currentSlot;
    }

    private void sync() {
        if (this.field_145850_b.field_72995_K) {
            TetraMod.packetHandler.sendToServer(new WorkbenchPacketUpdate(this.field_174879_c, this.currentSchematic, this.currentSlot));
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            this.func_70296_d();
        }
    }

    public ItemStack getTargetItemStack() {
        return this.handler.map(handler -> {
            ItemStack stack = handler.getStackInSlot(0);
            ItemStack placeholder = ItemUpgradeRegistry.instance.getReplacement(stack);
            if (!placeholder.func_190926_b()) {
                return placeholder;
            }
            return stack;
        }).orElse(ItemStack.field_190927_a);
    }

    public boolean isTargetPlaceholder() {
        return this.handler.map(handler -> handler.getStackInSlot(0)).map(stack -> ItemUpgradeRegistry.instance.getReplacement((ItemStack)stack)).map(placeholder -> !placeholder.func_190926_b()).orElse(false);
    }

    public ItemStack[] getMaterials() {
        return this.handler.map(handler -> {
            ItemStack[] result = new ItemStack[3];
            for (int i = 0; i < result.length; ++i) {
                result[i] = handler.getStackInSlot(i + 1).func_77946_l();
            }
            return result;
        }).orElse(new ItemStack[0]);
    }

    public void initiateCrafting(PlayerEntity player) {
        if (this.field_145850_b.field_72995_K) {
            TetraMod.packetHandler.sendToServer(new WorkbenchPacketCraft(this.field_174879_c));
        }
        this.craft(player);
        this.sync();
    }

    public void craft(PlayerEntity player) {
        ItemStack targetStack;
        ItemStack upgradedStack = targetStack = this.getTargetItemStack();
        IModularItem item = CastOptional.cast(upgradedStack.func_77973_b(), IModularItem.class).orElse(null);
        BlockState blockState = this.func_195044_w();
        Map<ToolType, Integer> availableTools = PropertyHelper.getCombinedToolLevels(player, this.func_145831_w(), this.func_174877_v(), blockState);
        ItemStack[] materials = this.getMaterials();
        ItemStack[] materialsAltered = (ItemStack[])Arrays.stream(this.getMaterials()).map(ItemStack::func_77946_l).toArray(ItemStack[]::new);
        if (item != null && this.currentSchematic != null && this.currentSchematic.canApplyUpgrade(player, targetStack, materialsAltered, this.currentSlot, availableTools)) {
            float severity = this.currentSchematic.getSeverity(targetStack, materialsAltered, this.currentSlot);
            boolean willReplace = this.currentSchematic.willReplace(targetStack, materialsAltered, this.currentSlot);
            double durabilityFactor = upgradedStack.func_77984_f() ? (double)upgradedStack.func_77952_i() * 1.0 / (double)upgradedStack.func_77958_k() : 0.0;
            double honingFactor = MathHelper.func_151237_a((double)((double)item.getHoningProgress(upgradedStack) * 1.0 / (double)item.getHoningLimit(upgradedStack)), (double)0.0, (double)1.0);
            Map<ToolType, Integer> tools = this.currentSchematic.getRequiredToolLevels(targetStack, materials);
            upgradedStack = this.currentSchematic.applyUpgrade(targetStack, materialsAltered, true, this.currentSlot, player);
            upgradedStack = WorkbenchTile.applyCraftingBonusEffects(upgradedStack, this.currentSlot, willReplace, player, materials, materialsAltered, tools, this.field_145850_b, this.field_174879_c, blockState, true);
            for (Map.Entry<ToolType, Integer> entry : tools.entrySet()) {
                upgradedStack = WorkbenchTile.consumeCraftingToolEffects(upgradedStack, this.currentSlot, willReplace, entry.getKey(), entry.getValue(), player, this.field_145850_b, this.field_174879_c, blockState, true);
            }
            item.assemble(upgradedStack, this.field_145850_b, severity);
            if (this.currentSchematic.isHoning()) {
                IModularItem.removeHoneable(upgradedStack);
            } else if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() && !IModularItem.isHoneable(upgradedStack)) {
                item.setHoningProgress(upgradedStack, (int)Math.ceil(honingFactor * (double)item.getHoningLimit(upgradedStack)));
            }
            if (upgradedStack.func_77984_f() && !(this.currentSchematic instanceof RepairSchematic)) {
                if (durabilityFactor > 0.0 && willReplace && this.currentSlot.equals(item.getRepairSlot(upgradedStack))) {
                    item.repair(upgradedStack);
                } else {
                    upgradedStack.func_196085_b((int)Math.ceil(durabilityFactor * (double)upgradedStack.func_77958_k()));
                }
            }
            int xpCost = this.currentSchematic.getExperienceCost(targetStack, materials, this.currentSlot);
            if (!player.func_184812_l_() && xpCost > 0) {
                player.func_82242_a(-xpCost);
            }
        }
        ItemStack tempStack = upgradedStack;
        this.handler.ifPresent(handler -> {
            for (int i = 0; i < materialsAltered.length; ++i) {
                handler.setStackInSlot(i + 1, materialsAltered[i]);
            }
            this.emptyMaterialSlots(player);
            handler.setStackInSlot(0, tempStack);
        });
        this.clearSchematic();
    }

    public static ItemStack consumeCraftingToolEffects(ItemStack upgradedStack, String slot, boolean isReplacing, ToolType tool, int level, PlayerEntity player, World world, BlockPos pos, BlockState blockState, boolean consumeResources) {
        ItemStack providingStack = PropertyHelper.getPlayerProvidingItemStack(tool, level, (Entity)player);
        if (!providingStack.func_190926_b()) {
            if (providingStack.func_77973_b() instanceof IToolProvider) {
                upgradedStack = ((IToolProvider)providingStack.func_77973_b()).onCraftConsume(providingStack, upgradedStack, player, tool, level, consumeResources);
            }
        } else {
            ItemStack toolbeltResult = PropertyHelper.consumeCraftToolToolbelt(player, upgradedStack, tool, level, consumeResources);
            if (toolbeltResult != null) {
                upgradedStack = toolbeltResult;
            } else {
                ItemStack consumeTarget = upgradedStack;
                upgradedStack = CastOptional.cast(blockState.func_177230_c(), AbstractWorkbenchBlock.class).map(block -> block.onCraftConsumeTool(world, pos, blockState, consumeTarget, slot, isReplacing, player, tool, level, consumeResources)).orElse(upgradedStack);
            }
        }
        return upgradedStack;
    }

    public static ItemStack applyCraftingBonusEffects(ItemStack upgradedStack, String slot, boolean isReplacing, PlayerEntity player, ItemStack[] preMaterials, ItemStack[] postMaterials, Map<ToolType, Integer> tools, World world, BlockPos pos, BlockState blockState, boolean consumeResources) {
        ItemStack result = upgradedStack.func_77946_l();
        ResourceLocation[] unlockedEffects = CastOptional.cast(blockState.func_177230_c(), AbstractWorkbenchBlock.class).map(block -> block.getCraftingEffects(world, pos, blockState)).orElse(new ResourceLocation[0]);
        Arrays.stream(CraftingEffectRegistry.getEffects(unlockedEffects, upgradedStack, slot, isReplacing, player, preMaterials, tools, world, pos, blockState)).forEach(craftingEffect -> craftingEffect.applyOutcomes(result, slot, isReplacing, player, preMaterials, postMaterials, tools, world, pos, blockState, consumeResources));
        return result;
    }

    public ResourceLocation[] getUnlockedSchematics() {
        return CastOptional.cast(this.func_195044_w().func_177230_c(), AbstractWorkbenchBlock.class).map(block -> block.getSchematics(this.field_145850_b, this.field_174879_c, this.func_195044_w())).orElse(new ResourceLocation[0]);
    }

    public void applyTweaks(PlayerEntity player, String slot, Map<String, Integer> tweaks) {
        if (this.field_145850_b.field_72995_K) {
            TetraMod.packetHandler.sendToServer(new WorkbenchPacketTweak(this.field_174879_c, slot, tweaks));
        }
        this.tweak(player, slot, tweaks);
        this.sync();
    }

    public void tweak(PlayerEntity player, String slot, Map<String, Integer> tweaks) {
        this.handler.ifPresent(handler -> {
            ItemStack tweakedStack = this.getTargetItemStack().func_77946_l();
            CastOptional.cast(tweakedStack.func_77973_b(), IModularItem.class).ifPresent(item -> item.tweak(tweakedStack, slot, tweaks));
            handler.setStackInSlot(0, tweakedStack);
        });
    }

    public void addChangeListener(String key, Runnable runnable) {
        this.changeListeners.put(key, runnable);
    }

    public void removeChangeListener(String key) {
        this.changeListeners.remove(key);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.handler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l(inventoryKey)));
        String schematicKey = compound.func_74779_i(schematicKey);
        this.currentSchematic = SchematicRegistry.getSchematic(schematicKey);
        if (compound.func_74764_b(currentSlotKey)) {
            this.currentSlot = compound.func_74779_i(currentSlotKey);
        }
        this.interaction = ActionInteraction.create(this);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.handler.ifPresent(handler -> compound.func_218657_a(inventoryKey, (INBT)handler.serializeNBT()));
        if (this.currentSchematic != null) {
            compound.func_74778_a(schematicKey, this.currentSchematic.getKey());
        }
        if (this.currentSlot != null) {
            compound.func_74778_a(currentSlotKey, this.currentSlot);
        }
        return compound;
    }

    private void emptyMaterialSlots(PlayerEntity player) {
        this.handler.ifPresent(handler -> {
            for (int i = 1; i < handler.getSlots(); ++i) {
                this.transferStackToPlayer(player, i);
            }
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        });
    }

    private void emptyMaterialSlots() {
        this.handler.ifPresent(handler -> {
            if (!this.field_145850_b.field_72995_K) {
                for (int i = 1; i < 4; ++i) {
                    ItemStack materialStack = handler.extractItem(i, handler.getSlotLimit(i), false);
                    if (materialStack.func_190926_b()) continue;
                    ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, materialStack);
                    itemEntity.func_174869_p();
                    this.field_145850_b.func_217376_c((Entity)itemEntity);
                }
            } else {
                for (int i = 1; i < 4; ++i) {
                    handler.extractItem(i, handler.getSlotLimit(i), false);
                }
            }
        });
    }

    private void transferStackToPlayer(PlayerEntity player, int index) {
        this.handler.ifPresent(handler -> {
            ItemStack itemStack = handler.extractItem(index, handler.getSlotLimit(index), false);
            if (!itemStack.func_190926_b() && !player.field_71071_by.func_70441_a(itemStack)) {
                player.func_71019_a(itemStack, false);
            }
        });
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(unlocalizedName);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new WorkbenchContainer(windowId, this, (IInventory)playerInventory, playerEntity);
    }

    static {
        defaultActions = new WorkbenchAction[]{new RepairAction()};
        actions = new WorkbenchAction[0];
        DataManager.actionData.onReload(() -> {
            Object[] configActions = (WorkbenchAction[])DataManager.actionData.getData().values().stream().flatMap(Arrays::stream).toArray(ConfigAction[]::new);
            actions = (WorkbenchAction[])ArrayUtils.addAll((Object[])defaultActions, (Object[])configActions);
        });
    }
}

