/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.state.Property;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.scroll.QuadRenderer;
import se.mickelus.tetra.blocks.scroll.ScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.util.RotationHelper;

public class ScrollRenderer
extends TileEntityRenderer<ScrollTile> {
    public static final RenderMaterial material = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("tetra", "blocks/scroll"));
    private ModelRenderer[] rolledModel = new ModelRenderer[3];
    private ModelRenderer ribbonModel;
    private ModelRenderer[] wallModel = new ModelRenderer[3];
    private QuadRenderer[][] wallGlyphs;
    private ModelRenderer[] openModel = new ModelRenderer[3];
    private QuadRenderer[][] openGlyphs;
    private static final int availableGlyphs = 16;
    private static final int availableMaterials = 3;
    ModelRenderer transparent;

    public ScrollRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        int i;
        for (i = 0; i < 3; ++i) {
            this.rolledModel[i] = new ModelRenderer(128, 64, 34 * i, 4);
            this.rolledModel[i].func_228301_a_(1.0f, 0.0f, 7.0f, 14.0f, 3.0f, 3.0f, 0.0f);
            this.wallModel[i] = new ModelRenderer(128, 64, 34 * i, 0);
            this.wallModel[i].func_228301_a_(1.0f, 14.0f, 0.0f, 14.0f, 2.0f, 2.0f, 0.0f);
            this.wallModel[i].func_217178_a("face", 1.0f, 1.0f, 0.05f, 14, 13, 0, 0.0f, 34 * i, 10);
            this.openModel[i] = new ModelRenderer(128, 64, 34 * i, 0);
            this.openModel[i].func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 2.0f, 2.0f, 0.0f);
            this.openModel[i].func_228301_a_(1.0f, 0.0f, 14.0f, 14.0f, 2.0f, 2.0f, 0.0f);
            this.openModel[i].func_217178_a("face", 1.0f, 0.05f, 2.0f, 14, 0, 12, 0.0f, 34 * i - 12, 10);
        }
        this.ribbonModel = new ModelRenderer(128, 64, 0, 23);
        this.ribbonModel.func_228301_a_(7.0f, 0.0f, 7.0f, 2.0f, 3.0f, 3.0f, 0.001f);
        this.transparent = new ModelRenderer(128, 64, 0, 0);
        this.transparent.func_217178_a("face", 2.0f, 1.0f, 0.075f, 6, 13, 0, 0.0f, -6, 51);
        this.wallGlyphs = new QuadRenderer[2][];
        for (i = 0; i < this.wallGlyphs.length; ++i) {
            this.wallGlyphs[i] = new QuadRenderer[16];
        }
        for (i = 0; i < 16; ++i) {
            this.wallGlyphs[0][i] = new QuadRenderer(8.0f, 1.0f, 0.075f, 7.0f, 13.0f, i * 7, 51.0f, 128.0f, 64.0f, true, Direction.SOUTH);
            this.wallGlyphs[1][i] = new QuadRenderer(1.0f, 1.0f, 0.075f, 7.0f, 13.0f, i * 7, 51.0f, 128.0f, 64.0f, false, Direction.SOUTH);
        }
        this.openGlyphs = new QuadRenderer[4][];
        for (i = 0; i < this.openGlyphs.length; ++i) {
            this.openGlyphs[i] = new QuadRenderer[16];
        }
        for (i = 0; i < 16; ++i) {
            this.openGlyphs[0][i] = new QuadRenderer(1.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, true, Direction.UP);
            this.openGlyphs[1][i] = new QuadRenderer(8.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, false, Direction.UP);
            this.openGlyphs[2][i] = new QuadRenderer(1.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, true, Direction.UP);
            this.openGlyphs[3][i] = new QuadRenderer(8.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, false, Direction.UP);
        }
    }

    public void render(ScrollTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, rl -> RenderType.func_228638_b_((ResourceLocation)rl));
        ScrollData[] scrolls = tile.getScrolls();
        ScrollBlock.Arrangement arrangement = ((ScrollBlock)tile.func_195044_w().func_177230_c()).getArrangement();
        Direction direction = (Direction)tile.func_195044_w().func_177229_b((Property)RackBlock.facingProp);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(direction.func_229384_a_());
        matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        switch (arrangement) {
            case rolled: {
                this.renderRolled(scrolls, matrixStack, combinedLight, combinedOverlay, vertexBuilder);
                break;
            }
            case wall: {
                this.renderWall(scrolls, matrixStack, combinedLight, combinedOverlay, vertexBuilder);
                break;
            }
            case open: {
                this.renderOpen(scrolls, matrixStack, combinedLight, combinedOverlay, vertexBuilder);
            }
        }
        matrixStack.func_227865_b_();
        if (this.shouldDrawLabel(scrolls, tile.func_174877_v())) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            if (arrangement == ScrollBlock.Arrangement.wall) {
                matrixStack.func_227863_a_(direction.func_176734_d().func_229384_a_());
                matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.55, 0.4);
                this.drawLabel(scrolls[0], matrixStack, buffer, combinedLight);
            } else if (arrangement == ScrollBlock.Arrangement.open) {
                double angle = RotationHelper.getHorizontalAngle(Minecraft.func_71410_x().func_175606_aa().func_174824_e(partialTicks), Vector3d.func_237489_a_((Vector3i)tile.func_174877_v()));
                Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
                rotation.func_195890_a(Vector3f.field_229181_d_.func_229187_a_((float)(angle / Math.PI * 180.0 + 180.0)));
                matrixStack.func_227863_a_(rotation);
                matrixStack.func_227861_a_(0.0, (double)0.4f, 0.4);
                this.drawLabel(scrolls[0], matrixStack, buffer, combinedLight);
            }
            matrixStack.func_227865_b_();
        }
    }

    private void renderRolled(ScrollData[] scrolls, MatrixStack matrixStack, int combinedLight, int combinedOverlay, IVertexBuilder vertexBuilder) {
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        int offset = Math.min(scrolls.length, 3) - 1;
        if (offset > 0) {
            matrixStack.func_227861_a_(0.0, 0.0, (double)offset * -0.125);
        }
        for (int i = 0; i < scrolls.length; ++i) {
            int mat = this.getMaterial(scrolls, i);
            float red = (float)ColorHelper.PackedColor.func_233007_b_((int)scrolls[i].ribbon) / 255.0f;
            float green = (float)ColorHelper.PackedColor.func_233008_c_((int)scrolls[i].ribbon) / 255.0f;
            float blue = (float)ColorHelper.PackedColor.func_233009_d_((int)scrolls[i].ribbon) / 255.0f;
            this.rolledModel[mat].func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            this.ribbonModel.func_228309_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, red, green, blue, 1.0f);
            matrixStack.func_227861_a_(0.0, 0.0, 0.25);
            if (i == 2) {
                matrixStack.func_227861_a_(0.0, 0.1875, -0.625);
                continue;
            }
            if (i != 4) continue;
            matrixStack.func_227861_a_(0.0, 0.1875, -0.375);
        }
    }

    private void renderWall(ScrollData[] scrolls, MatrixStack matrixStack, int combinedLight, int combinedOverlay, IVertexBuilder vertexBuilder) {
        int mat = this.getMaterial(scrolls, 0);
        int color = this.getGlyphColor(mat);
        float red = (float)ColorHelper.PackedColor.func_233007_b_((int)color) / 255.0f;
        float green = (float)ColorHelper.PackedColor.func_233008_c_((int)color) / 255.0f;
        float blue = (float)ColorHelper.PackedColor.func_233009_d_((int)color) / 255.0f;
        this.wallModel[mat].func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        for (int i = 0; i < this.wallGlyphs.length; ++i) {
            int glyph = this.getGlyph(scrolls, i);
            this.wallGlyphs[i][glyph].render(matrixStack, vertexBuilder, combinedLight, combinedOverlay, red, green, blue, 1.0f);
        }
    }

    private void renderOpen(ScrollData[] scrolls, MatrixStack matrixStack, int combinedLight, int combinedOverlay, IVertexBuilder vertexBuilder) {
        int mat = this.getMaterial(scrolls, 0);
        int color = this.getGlyphColor(mat);
        float red = (float)ColorHelper.PackedColor.func_233007_b_((int)color) / 255.0f;
        float green = (float)ColorHelper.PackedColor.func_233008_c_((int)color) / 255.0f;
        float blue = (float)ColorHelper.PackedColor.func_233009_d_((int)color) / 255.0f;
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        this.openModel[mat].func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        for (int i = 0; i < this.openGlyphs.length; ++i) {
            if (i == 2) {
                matrixStack.func_227861_a_(0.5, 0.0, 0.5);
                matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
            }
            int glyph = this.getGlyph(scrolls, i);
            this.openGlyphs[i][glyph].render(matrixStack, vertexBuilder, combinedLight, combinedOverlay, red, green, blue, 1.0f);
        }
    }

    private int getGlyphColor(int material) {
        switch (material) {
            case 2: {
                return 12558634;
            }
            case 1: {
                return 9411532;
            }
        }
        return 6709063;
    }

    private int getGlyph(ScrollData[] data, int index) {
        if (data.length > 0) {
            if (data[0].glyphs.size() > index) {
                return MathHelper.func_76125_a((int)data[0].glyphs.get(index), (int)0, (int)16);
            }
            if (data[0].glyphs.size() > 0) {
                return MathHelper.func_76125_a((int)data[0].glyphs.get(0), (int)0, (int)16);
            }
        }
        return 0;
    }

    private int getMaterial(ScrollData[] data, int index) {
        if (data.length > index) {
            return MathHelper.func_76125_a((int)data[index].material, (int)0, (int)2);
        }
        return 0;
    }

    private boolean shouldDrawLabel(ScrollData[] scrolls, BlockPos pos) {
        RayTraceResult mouseover = Minecraft.func_71410_x().field_71476_x;
        return scrolls != null && scrolls.length > 0 && mouseover != null && mouseover.func_216346_c() == RayTraceResult.Type.BLOCK && pos.equals((Object)((BlockRayTraceResult)mouseover).func_216350_a());
    }

    private void drawLabel(ScrollData scroll, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        String label = I18n.func_135052_a((String)("item.tetra.scroll." + scroll.key + ".name"), (Object[])new Object[0]);
        matrixStack.func_227862_a_(-0.0125f, -0.0125f, 0.0125f);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        FontRenderer fontrenderer = this.field_228858_b_.field_147557_n;
        float x = (float)(-fontrenderer.func_78256_a(label)) / 2.0f;
        fontrenderer.func_238411_a_(label, x + 1.0f, 0.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        fontrenderer.func_238411_a_(label, x - 1.0f, 0.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        fontrenderer.func_238411_a_(label, x, -1.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        fontrenderer.func_238411_a_(label, x, 1.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        matrixStack.func_227861_a_(0.0, 0.0, (double)-0.0125f);
        fontrenderer.func_238411_a_(label, x, 0.0f, -1, false, matrix4f, buffer, false, 0, packedLight, false);
    }
}

