/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorTile;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileRenderer;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.util.TileEntityOptional;

public class ChthonicExtractorBlock
extends TetraBlock
implements IInteractiveBlock {
    public static final String unlocalizedName = "chthonic_extractor";
    @ObjectHolder(value="tetra:chthonic_extractor")
    public static ChthonicExtractorBlock instance;
    public static final String description = "block.tetra.chthonic_extractor.description";
    public static final String extendedDescription = "block.tetra.chthonic_extractor.description_extended";
    static final BlockInteraction[] interactions;
    protected static final VoxelShape shape;
    @ObjectHolder(value="tetra:chthonic_extractor")
    public static Item item;
    @ObjectHolder(value="tetra:chthonic_extractor_used")
    public static Item usedItem;
    public static final int maxDamage = 1024;

    public ChthonicExtractorBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)ForgedBlockCommon.forgedMaterialNotSolid, (MaterialColor)MaterialColor.field_151670_w).func_200947_a(SoundType.field_235594_P_).func_200948_a(4.0f, 2400.0f));
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
    }

    @Override
    public void clientInit() {
        RenderingRegistry.registerEntityRenderingHandler(ExtractorProjectileEntity.type, ExtractorProjectileRenderer::new);
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        Item usedItem = (Item)new BlockItem((Block)this, new Item.Properties().func_200918_c(1024)).setRegistryName(this.getRegistryName() + "_used");
        registry.register((IForgeRegistryEntry)usedItem);
        Item item = (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a((ItemGroup)TetraItemGroup.instance).func_200917_a(64)).setRegistryName(this.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent(description).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        if (Screen.func_231173_s_()) {
            tooltip.add(Tooltips.expanded);
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add(ForgedBlockCommon.locationTooltip);
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add((ITextComponent)new TranslationTextComponent(extendedDescription).func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add(Tooltips.expand);
        }
    }

    private static boolean hit(World world, BlockPos pos, @Nullable PlayerEntity playerEntity, Hand hand) {
        if (((Boolean)ConfigHandler.enableExtractor.get()).booleanValue()) {
            int amount = Optional.ofNullable(playerEntity).map(player -> player.func_184586_b(hand)).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).map(itemStack -> Float.valueOf(((IToolProvider)itemStack.func_77973_b()).getToolEfficiency((ItemStack)itemStack, ToolTypes.hammer))).map(Math::round).orElse(4);
            TileEntityOptional.from((IBlockReader)world, pos, ChthonicExtractorTile.class).ifPresent(tile -> tile.damage(amount));
            FracturedBedrockBlock.pierce(world, pos.func_177977_b(), amount);
            world.func_184133_a(playerEntity, pos, SoundEvents.field_232778_ji_, SoundCategory.PLAYERS, 0.8f, 0.5f);
            return true;
        }
        return false;
    }

    private static int getTier(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockReader)world, pos.func_177977_b(), FracturedBedrockTile.class).map(FracturedBedrockTile::getProjectedTier).orElseGet(() -> FracturedBedrockBlock.canPierce(world, pos.func_177977_b()) ? 0 : -1);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityOptional.from((IBlockReader)world, pos, ChthonicExtractorTile.class).ifPresent(tile -> tile.setDamage(stack.func_77952_i()));
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntityOptional.from((IBlockReader)world, pos, ChthonicExtractorTile.class).ifPresent(tile -> {
            ItemStack itemStack = this.getItemStack((ChthonicExtractorTile)((Object)tile));
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack);
            itemEntity.func_174869_p();
            world.func_217376_c((Entity)itemEntity);
        });
        super.func_176208_a(world, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof ChthonicExtractorTile) {
            builder = builder.func_216017_a(new ResourceLocation("tetra:cthtonic_drop"), (context, stackConsumer) -> stackConsumer.accept(this.getItemStack((ChthonicExtractorTile)tile)));
        }
        return super.func_220076_a(state, builder);
    }

    private ItemStack getItemStack(ChthonicExtractorTile tile) {
        if (tile.getDamage() > 0) {
            ItemStack itemStack = new ItemStack((IItemProvider)usedItem);
            itemStack.func_196085_b(tile.getDamage());
            return itemStack;
        }
        return new ItemStack((IItemProvider)item);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ChthonicExtractorTile();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(World world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolType> tools) {
        int tier = ChthonicExtractorBlock.getTier(world, pos);
        if (((Boolean)ConfigHandler.enableExtractor.get()).booleanValue() && tier >= 0 && face == Direction.UP) {
            return new BlockInteraction[]{interactions[Math.min(tier, interactions.length - 1)]};
        }
        return new BlockInteraction[0];
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    static {
        interactions = new BlockInteraction[]{new BlockInteraction(ToolTypes.hammer, 4, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand)), new BlockInteraction(ToolTypes.hammer, 5, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand)), new BlockInteraction(ToolTypes.hammer, 6, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand)), new BlockInteraction(ToolTypes.hammer, 7, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand))};
        shape = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    }
}

