/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.icon.CustomIconItem;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.LazyIcon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.Objects;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemIcon
extends Icon {
    private final ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        if (stack.func_190926_b()) {
            return EMPTY;
        }
        if (stack.func_77973_b() instanceof CustomIconItem) {
            return ((CustomIconItem)stack.func_77973_b()).getCustomIcon(stack);
        }
        return new ItemIcon(stack);
    }

    public static Icon getItemIcon(Item item) {
        return item == Items.field_190931_a ? EMPTY : ItemIcon.getItemIcon(new ItemStack((IItemProvider)item));
    }

    public static Icon getItemIcon(final String lazyStackString) {
        if (lazyStackString.isEmpty()) {
            return EMPTY;
        }
        return new LazyIcon(() -> {
            String[] s = lazyStackString.split(" ", 4);
            ItemStack stack = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(s[0])));
            if (s.length >= 2 && !s[1].equals("1")) {
                stack.func_190920_e(Integer.parseInt(s[1]));
            }
            if (s.length >= 3 && !s[2].equals("0")) {
                stack.func_196085_b(Integer.parseInt(s[2]));
            }
            if (s.length >= 4 && !s[3].equals("null")) {
                try {
                    stack.func_77982_d(JsonToNBT.func_180713_a((String)s[3]));
                }
                catch (CommandSyntaxException ex) {
                    ex.printStackTrace();
                }
            }
            if (stack.func_190926_b()) {
                stack = new ItemStack((IItemProvider)Items.field_221803_eL);
                stack.func_200302_a((ITextComponent)new StringTextComponent(lazyStackString));
            }
            return ItemIcon.getItemIcon(stack);
        }){

            @Override
            public String toString() {
                return "item:" + lazyStackString;
            }
        };
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStack, int x, int y, int w, int h) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 100.0);
        GuiHelper.drawItem(matrixStack, this.getStack(), x, y, (float)w / 16.0f, (float)h / 16.0f, true, null);
        matrixStack.func_227865_b_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawStatic(MatrixStack matrixStack, int x, int y, int w, int h) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 100.0);
        GuiHelper.drawItem(matrixStack, this.getStack(), x, y, (float)w / 16.0f, (float)h / 16.0f, false, null);
        matrixStack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawItem3D(MatrixStack matrixStack, ItemStack stack) {
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, 240, OverlayTexture.field_229196_a_, matrixStack, (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw3D(MatrixStack matrixStack) {
        ItemIcon.drawItem3D(matrixStack, this.getStack());
    }

    public String toString() {
        ItemStack is = this.getStack();
        StringBuilder builder = new StringBuilder("item:");
        builder.append(Registries.getId((Object)is.func_77973_b(), (RegistryKey)Registry.field_239714_o_));
        int count = is.func_190916_E();
        int damage = is.func_77952_i();
        CompoundNBT nbt = is.func_77978_p();
        if (count > 1 || damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(damage);
        }
        if (nbt != null) {
            builder.append(' ');
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public int hashCode() {
        ItemStack stack = this.getStack();
        int h = stack.func_77973_b().hashCode();
        h = h * 31 + stack.func_190916_E();
        h = h * 31 + Objects.hashCode(stack.func_77978_p());
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && ItemStack.func_77989_b((ItemStack)this.getStack(), (ItemStack)((ItemIcon)o).getStack());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getStack();
    }
}

