/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mgui.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.ResourceLocation;
import se.mickelus.mgui.gui.GuiElement;

public class GuiTexture
extends GuiElement {
    protected ResourceLocation textureLocation;
    protected int textureX;
    protected int textureY;
    protected int color = 0xFFFFFF;

    public GuiTexture(int x, int y, int width, int height, ResourceLocation textureLocation) {
        this(x, y, width, height, 0, 0, textureLocation);
    }

    public GuiTexture(int x, int y, int width, int height, int textureX, int textureY, ResourceLocation textureLocation) {
        super(x, y, width, height);
        this.textureX = textureX;
        this.textureY = textureY;
        this.textureLocation = textureLocation;
    }

    public GuiTexture setTextureCoordinates(int x, int y) {
        this.textureX = x;
        this.textureY = y;
        return this;
    }

    public GuiTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        GuiTexture.drawTexture(matrixStack, this.textureLocation, refX + this.x, refY + this.y, this.width, this.height, this.textureX, this.textureY, this.color, this.getOpacity() * opacity);
    }
}

