/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.util;

import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.util.BiomeUtil;
import com.legacy.blue_skies.world.general_layers.BiomeMutationLayer;
import com.legacy.structure_gel.registrars.BiomeRegistrar;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class BiomeIDs {
    private static BiomeIDs instance = new BiomeIDs();
    public final int CALMING_SKIES = this.get(SkiesBiomes.CALMING_SKIES);
    public final int MIDDAY_SHORE = this.get(SkiesBiomes.MIDDAY_SHORE);
    public final int SLUSHLANDS = this.get(SkiesBiomes.SLUSHLANDS);
    public final int FROSTBITTEN_FOREST = this.get(SkiesBiomes.FROSTBITTEN_FOREST);
    public final int FROSTBITTEN_FOREST_CLEARING = this.get(SkiesBiomes.FROSTBITTEN_FOREST_CLEARING);
    public final int RISING_CREEK = this.get(SkiesBiomes.RISING_CREEK);
    public final int CRESCENT_ORCHARD = this.get(SkiesBiomes.CRESCENT_ORCHARD);
    public final int CRESCENT_ORCHARD_LAKE = this.get(SkiesBiomes.CRESCENT_ORCHARD_LAKE);
    public final int CRYSTAL_DUNES = this.get(SkiesBiomes.CRYSTAL_DUNES);
    public final int CRYSTAL_DUNES_SPIKES = this.get(SkiesBiomes.CRYSTAL_DUNES_SPIKES);
    public final int PEEKING_OCEAN = this.get(SkiesBiomes.PEEKING_OCEAN);
    public final int DEEP_PEEKING_OCEAN = this.get(SkiesBiomes.DEEP_PEEKING_OCEAN);
    public final int BRUMBLE_FOREST = this.get(SkiesBiomes.BRUMBLE_FOREST);
    public final int WARM_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_203614_T);
    public final int DEEP_WARM_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_203617_W);
    public final int LUKEWARM_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_203615_U);
    public final int DEEP_LUKEWARM_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_203618_X);
    public final int OCEAN = this.get((RegistryKey<Biome>)Biomes.field_76771_b);
    public final int DEEP_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_150575_M);
    public final int COLD_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_203616_V);
    public final int DEEP_COLD_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_203619_Y);
    public final int FROZEN_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_76776_l);
    public final int DEEP_FROZEN_OCEAN = this.get((RegistryKey<Biome>)Biomes.field_203620_Z);

    private int get(BiomeRegistrar biome) {
        return BiomeUtil.getBiomeId((RegistryKey<Biome>)biome.getKey());
    }

    private int get(RegistryKey<Biome> biome) {
        return BiomeUtil.getBiomeId(biome);
    }

    public static BiomeIDs getInstance() {
        return instance;
    }

    public static void reset() {
        instance = new BiomeIDs();
        for (BiomeMutationLayer layer : BiomeMutationLayer.values()) {
            layer.reset();
        }
    }

    public static boolean isOcean(int biome) {
        return biome == BiomeIDs.instance.PEEKING_OCEAN || biome == BiomeIDs.instance.DEEP_PEEKING_OCEAN || biome == BiomeIDs.instance.BRUMBLE_FOREST || biome == BiomeIDs.instance.OCEAN || biome == BiomeIDs.instance.DEEP_OCEAN || biome == BiomeIDs.instance.WARM_OCEAN || biome == BiomeIDs.instance.LUKEWARM_OCEAN || biome == BiomeIDs.instance.COLD_OCEAN || biome == BiomeIDs.instance.FROZEN_OCEAN || biome == BiomeIDs.instance.DEEP_WARM_OCEAN || biome == BiomeIDs.instance.DEEP_FROZEN_OCEAN || biome == BiomeIDs.instance.DEEP_COLD_OCEAN || biome == BiomeIDs.instance.DEEP_LUKEWARM_OCEAN;
    }

    public static boolean isShallowOcean(int biome) {
        return biome == BiomeIDs.instance.PEEKING_OCEAN || biome == BiomeIDs.instance.OCEAN || biome == BiomeIDs.instance.WARM_OCEAN || biome == BiomeIDs.instance.LUKEWARM_OCEAN || biome == BiomeIDs.instance.COLD_OCEAN || biome == BiomeIDs.instance.FROZEN_OCEAN;
    }
}

