/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures.villages;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageProfessions;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SkiesVillageStructure
extends GelJigsawStructure {
    public SkiesVillageStructure(Codec<VillageConfig> config) {
        super(config, 0, true, true);
    }

    public double getProbability() {
        return 1.0;
    }

    public int getSpacing() {
        return 15;
    }

    public int getOffset() {
        return this.getSpacing() / 3;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, VillageConfig config) {
        return super.func_230363_a_(chunkGen, biomeProvider, seed, sharedSeedRand, chunkPosX, chunkPosZ, biomeIn, chunkPos, (IFeatureConfig)config) && !this.isDungeonClose(chunkGen, seed, sharedSeedRand, chunkPosX, chunkPosZ);
    }

    private boolean isDungeonClose(ChunkGenerator chunkGen, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ) {
        for (Structure<?> dungeon : SkiesStructures.dungeons) {
            int range = 7;
            for (int x = chunkPosX - range; x <= chunkPosX + range; ++x) {
                for (int z = chunkPosZ - range; z <= chunkPosZ + range; ++z) {
                    ChunkPos chunkpos = dungeon.func_236392_a_(null, seed, sharedSeedRand, x, z);
                    if (x != chunkpos.field_77276_a || z != chunkpos.field_77275_b) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        private static final Map<String, EntityType<?>> BASIC_SPAWNS = new HashMap();

        public Piece(TemplateManager templateManager, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox bounds) {
            super(templateManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(templateManager, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            if (BASIC_SPAWNS.containsKey(key)) {
                this.spawnEntity(BASIC_SPAWNS.get(key), pos, world, rand, null);
                return;
            }
            if (key.equals("cod")) {
                this.spawnEntity(EntityType.field_203780_j, pos, world, rand, cod -> {
                    world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
                    cod.func_110163_bv();
                });
                return;
            }
            if (key.contains("villager")) {
                this.spawnEntity(EntityType.field_200756_av, pos, world, rand, villager -> {
                    if (key.contains("-")) {
                        villager.func_213753_a(villager.func_213700_eh().func_221134_a(Registry.field_218369_K.func_241873_b(BlueSkies.locate(key.split("-")[1])).orElseGet(() -> SkiesVillagers.CALMING_SKIES)));
                    }
                    if (rand.nextFloat() < 0.1f) {
                        if (rand.nextBoolean()) {
                            villager.func_213753_a(villager.func_213700_eh().func_221126_a(VillagerProfession.field_221162_l));
                        } else {
                            villager.func_82227_f(true);
                        }
                    }
                });
                return;
            }
            if (key.startsWith("chest")) {
                SkiesVillageBiomes biome;
                this.setAir((IWorld)world, pos);
                String[] data = key.split("-");
                ResourceLocation lootTable = LootTables.field_215826_q;
                if (data.length > 2) {
                    SkiesVillageProfessions profession = SkiesVillageProfessions.from(data[2]);
                    if (profession != null) {
                        if (data[1].equals("bright")) {
                            lootTable = SkiesLootProv.VILLAGE_EVERBRIGHT_PROFESSIONS.get((Object)profession);
                        } else if (data[1].equals("dawn")) {
                            lootTable = SkiesLootProv.VILLAGE_EVERDAWN_PROFESSIONS.get((Object)profession);
                        }
                    }
                } else if (data.length > 1 && (biome = SkiesVillageBiomes.from(data[1])) != null) {
                    lootTable = SkiesLootProv.VILLAGE_BIOME_CHESTS.get((Object)biome);
                }
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)lootTable);
                return;
            }
        }

        private <T extends Entity> void spawnEntity(EntityType<T> entityType, BlockPos pos, IServerWorld world, Random rand, @Nullable Consumer<T> modifyEntity) {
            this.setAir((IWorld)world, pos);
            Entity entity = this.createEntity(entityType, world, pos, this.field_214834_c);
            if (modifyEntity != null) {
                modifyEntity.accept(entity);
            }
            if (entity instanceof MobEntity) {
                ((MobEntity)entity).func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
            }
            world.func_217376_c(entity);
        }

        public IStructurePieceType func_214807_k() {
            return SkiesStructures.BLUE_SKIES_VILLAGE.getPieceType();
        }

        static {
            BASIC_SPAWNS.put("golem", EntityType.field_200757_aw);
            BASIC_SPAWNS.put("azulfo", SkiesEntityTypes.AZULFO);
            BASIC_SPAWNS.put("ram", SkiesEntityTypes.STARDUST_RAM);
            BASIC_SPAWNS.put("monitor", SkiesEntityTypes.SHADE_MONITOR);
            BASIC_SPAWNS.put("camel", SkiesEntityTypes.CRYSTAL_CAMEL);
        }
    }
}

