/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;

public class CherryTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.cherry_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.cherry_leaves.func_176223_P();
    private final boolean fromDungeon;

    public CherryTreeFeature(Codec<BaseTreeFeatureConfig> config, boolean fromDungeonIn) {
        super(config, true);
        this.fromDungeon = fromDungeonIn;
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        if (this.fromDungeon && (!world.func_241827_a(SectionPos.func_218167_a((BlockPos)pos), SkiesStructures.NATURE_DUNGEON.getStructure()).findAny().isPresent() || world.func_180495_p(pos.func_177977_b()).func_177230_c() != SkiesBlocks.turquoise_cherry_grass_block)) {
            return false;
        }
        int height = rand.nextInt(3) + 10;
        if (!this.isAreaOk(world, pos, height, 1, height - 4, 7)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.func_177981_b(y), LOG, bounds);
        }
        this.setLeafBall(changedLeaves, world, pos.func_177982_a(0, height - 2, 0), bounds);
        this.setBranches(changedLogs, changedLeaves, world, rand, pos, bounds, height);
        this.setSideLogs(changedLogs, world, pos, bounds);
        return true;
    }

    protected void setBranches(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, ISeedReader world, Random rand, BlockPos pos, MutableBoundingBox bounds, int height) {
        int i;
        int iPosX = height - 4 - rand.nextInt(3);
        int iNegX = height - 4 - rand.nextInt(3);
        int iPosZ = height - 4 - rand.nextInt(3);
        int iNegZ = height - 4 - rand.nextInt(3);
        for (i = 1; i <= 3; ++i) {
            if (i == 3) {
                this.setLeafBall(changedLeaves, world, pos.func_177982_a(i, iPosX + 2, rand.nextInt(3) - 1), bounds);
                this.setLeafBall(changedLeaves, world, pos.func_177982_a(rand.nextInt(3) - 1, iPosZ + 2, i), bounds);
            }
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(i, iPosX + i, 0), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, iPosZ + i, i), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
        }
        for (i = -1; i >= -3; --i) {
            if (i == -3) {
                this.setLeafBall(changedLeaves, world, pos.func_177982_a(i, iNegX + 2, rand.nextInt(3) - 1), bounds);
                this.setLeafBall(changedLeaves, world, pos.func_177982_a(rand.nextInt(3) - 1, iNegZ + 2, i), bounds);
            }
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(i, iNegX - i, 0), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, iNegZ - i, i), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
        }
    }

    protected void setLeafBall(Set<BlockPos> changedLeaves, ISeedReader world, BlockPos pos, MutableBoundingBox bounds) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, y, z), LEAF, bounds);
                }
            }
        }
        this.setLeafCap(changedLeaves, world, pos.func_177977_b(), bounds);
        this.setLeafCap(changedLeaves, world, pos.func_177981_b(3), bounds);
    }

    protected void setLeafCap(Set<BlockPos> changedLeaves, ISeedReader world, BlockPos pos, MutableBoundingBox bounds) {
        this.setBlockIfOk(changedLeaves, world, pos, LEAF, bounds);
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            this.setBlockIfOk(changedLeaves, world, pos.func_177972_a(dir), LEAF, bounds);
        }
    }

    protected void setSideLogs(Set<BlockPos> changedLogs, ISeedReader world, BlockPos pos, MutableBoundingBox bounds) {
        for (int i = 0; i >= -1; --i) {
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(1, i, 0), LOG, bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(-1, i, 0), LOG, bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, i, 1), LOG, bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, i, -1), LOG, bounds);
        }
    }

    @Override
    public boolean isAllowedInside(Structure<?> structure) {
        return true;
    }
}

