/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.IStructureRestricted;
import com.legacy.structure_gel.util.Internal;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.structure.Structure;

public abstract class AbstractSkyTreeFeature
extends TreeFeature
implements IStructureRestricted {
    private static final Map<Direction, BooleanProperty> VINE_PROPERTIES = (Map)VineBlock.field_196546_A.entrySet().stream().filter(e -> e.getKey() != Direction.UP).collect(Util.func_199749_a());
    protected final boolean natural;

    public AbstractSkyTreeFeature(Codec<BaseTreeFeatureConfig> config, boolean natural) {
        super(config);
        this.natural = natural;
    }

    @Internal
    public final boolean func_225557_a_(IWorldGenerationReader worldGenReader, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds, BaseTreeFeatureConfig config) {
        ISeedReader world;
        if (worldGenReader instanceof ISeedReader && this.isValidGround(world = (ISeedReader)worldGenReader, world.func_180495_p(pos.func_177977_b()), pos.func_177977_b()) && this.shouldGenerate(world, pos)) {
            return this.place(world, rand, pos, changedLogs, changedLeaves, bounds);
        }
        return false;
    }

    public abstract boolean place(ISeedReader var1, Random var2, BlockPos var3, Set<BlockPos> var4, Set<BlockPos> var5, MutableBoundingBox var6);

    @Override
    public boolean isAllowedInside(Structure<?> structure) {
        return structure != SkiesStructures.NATURE_DUNGEON.getStructure() && structure != SkiesStructures.BLUE_SKIES_VILLAGE.getStructure();
    }

    public boolean isValidGround(ISeedReader world, BlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (this.natural) {
            return AbstractSkyTreeFeature.func_227250_b_((Block)block);
        }
        return AbstractSkyTreeFeature.func_227250_b_((Block)block) || block instanceof FarmlandBlock;
    }

    protected boolean setBlockIfOk(@Nullable Set<BlockPos> changedBlocks, ISeedReader world, BlockPos pos, BlockState state, MutableBoundingBox bounds) {
        Block block = state.func_177230_c();
        if (block instanceof RotatedPillarBlock) {
            if (this.isReplaceableByLogs(world, pos)) {
                this.setBlock(changedBlocks, world, pos, state, bounds);
                return true;
            }
            return false;
        }
        if (block instanceof LeavesBlock) {
            if (this.isReplaceableByLeaves(world, pos)) {
                this.setBlock(changedBlocks, world, pos, state, bounds);
                return true;
            }
            return false;
        }
        if (world.func_175623_d(pos) && state.func_196955_c((IWorldReader)world, pos)) {
            BlockState lower;
            this.setBlock(changedBlocks, world, pos, state, bounds);
            if (block instanceof SnowBlock && (lower = world.func_180495_p(pos.func_177977_b())).func_235901_b_((Property)BlockStateProperties.field_208196_w)) {
                world.func_180501_a(pos.func_177977_b(), (BlockState)lower.func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(true)), 3);
            }
            return true;
        }
        return false;
    }

    protected void setBlock(@Nullable Set<BlockPos> changedBlocks, ISeedReader world, BlockPos pos, BlockState state, MutableBoundingBox bounds) {
        TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)pos, (BlockState)state);
        bounds.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
        if (changedBlocks != null) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    public boolean isReplaceableByLeaves(ISeedReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.canBeReplacedByLeaves((IWorldReader)world, pos) || state.func_177230_c() == Blocks.field_150433_aE;
    }

    public boolean isReplaceableByLogs(ISeedReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.canBeReplacedByLogs((IWorldReader)world, pos) || state.func_177230_c() instanceof BushBlock || state.func_177230_c() == Blocks.field_150433_aE || state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public boolean isLeavesOrLog(BlockState state) {
        return state.func_235714_a_((ITag)BlockTags.field_200031_h) || state.func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    public static void placeVines(ISeedReader world, BlockPos trunkStart, Random rand, int areaWidth, int areaHeight, int minVineLength, int maxVineLength, float placementChance, VineBlock vine, Set<Block> allowedAttachmentBlocks) {
        int halfWidth = Math.max((areaWidth - 1) / 2, 1);
        for (int x = -halfWidth; x <= halfWidth; ++x) {
            for (int z = -halfWidth; z <= halfWidth; ++z) {
                for (int y = 2; y <= areaHeight; ++y) {
                    BlockPos offsetPos = trunkStart.func_177982_a(x, y, z);
                    if (!world.func_175623_d(offsetPos) || !(rand.nextFloat() < placementChance)) continue;
                    for (Map.Entry<Direction, BooleanProperty> prop : VINE_PROPERTIES.entrySet()) {
                        BlockState vineBlock = (BlockState)vine.func_176223_P().func_206870_a((Property)prop.getValue(), (Comparable)Boolean.valueOf(true));
                        if (!vineBlock.func_196955_c((IWorldReader)world, offsetPos) || !allowedAttachmentBlocks.isEmpty() && !allowedAttachmentBlocks.contains(world.func_180495_p(offsetPos.func_177972_a(prop.getKey())).func_177230_c())) continue;
                        int maxLength = rand.nextInt(maxVineLength - minVineLength) + minVineLength;
                        for (int vineLength = 0; vineLength <= maxLength && world.func_175623_d(offsetPos.func_177979_c(vineLength)) && vineBlock.func_196955_c((IWorldReader)world, offsetPos); ++vineLength) {
                            world.func_180501_a(offsetPos.func_177979_c(vineLength), vineBlock, 7);
                        }
                    }
                }
            }
        }
    }

    public boolean isAreaOk(ISeedReader world, BlockPos pos, int trunkHeight, int trunkWidth, int leafStartHeight, int leafWidth) {
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + trunkHeight + 1 < world.func_234938_ad_()) {
            int y;
            if (trunkWidth == 1) {
                for (y = 0; y <= 1 + trunkHeight && pos.func_177956_o() + y >= 1 && pos.func_177956_o() + y < world.func_234938_ad_(); ++y) {
                    if (this.isReplaceableByLogs(world, pos.func_177981_b(y)) || this.isLeavesOrLog(world.func_180495_p(pos.func_177981_b(y)))) continue;
                    return false;
                }
            } else {
                for (y = 0; y <= 1 + trunkHeight && pos.func_177956_o() + y >= 1 && pos.func_177956_o() + y < world.func_234938_ad_(); ++y) {
                    for (int x = 0; x < trunkWidth; ++x) {
                        for (int z = 0; z < trunkWidth; ++z) {
                            if (this.isReplaceableByLogs(world, pos.func_177982_a(x, y, z)) || this.isLeavesOrLog(world.func_180495_p(pos.func_177982_a(x, y, z)))) continue;
                            return false;
                        }
                    }
                }
            }
            int width = Math.max((leafWidth - 1) / 2, 1);
            for (int y2 = leafStartHeight; y2 <= trunkHeight + 2 && pos.func_177956_o() + y2 >= 0 && pos.func_177956_o() + y2 < world.func_234938_ad_(); ++y2) {
                for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        if (this.isReplaceableByLeaves(world, pos.func_177982_a(x, y2, z)) || this.isLeavesOrLog(world.func_180495_p(pos.func_177982_a(x, y2, z)))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

