/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.dungeon.PoisonKeystoneBlock;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.util.structure_processors.VinesProcessor;
import com.legacy.structure_gel.worldgen.GelPlacementSettings;
import com.legacy.structure_gel.worldgen.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.worldgen.processors.RemoveGelStructureProcessor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PoisonDungeonPieces {
    private static final ResourceLocation TREE = BlueSkies.locate("dungeons/everdawn/poison/tree");
    private static final ResourceLocation TUNNEL = BlueSkies.locate("dungeons/everdawn/poison/entry_tunnel");

    public static void assemble(TemplateManager templateManager, BlockPos surfacePos, Rotation rotation, List<StructurePiece> components, Random rand) {
        int i;
        ArrayList<Floor> floors = new ArrayList<Floor>();
        int y = 45;
        floors.add(new Floor(0, new BlockPos(surfacePos.func_177958_n(), y, surfacePos.func_177952_p()), (Pair<Integer, Integer>)Pair.of((Object)8, (Object)8), rand));
        for (i = 0; i < 3; ++i) {
            floors.add(new Floor(i + 1, new BlockPos(surfacePos.func_177958_n(), y - (i + 1) * 10, surfacePos.func_177952_p()), ((Floor)floors.get((int)i)).exitPair, rand));
        }
        floors.add(new BossFloor(floors.size(), new BlockPos(surfacePos.func_177958_n(), y - floors.size() * 10, surfacePos.func_177952_p()), ((Floor)floors.get((int)(floors.size() - 1))).exitPair, rand));
        floors.forEach(floor -> floor.addPieces(components, templateManager));
        for (i = y + 5; i <= surfacePos.func_177956_o(); ++i) {
            components.add((StructurePiece)new Piece(templateManager, new BlockPos(surfacePos.func_177958_n() + 2, i, surfacePos.func_177952_p() + 2), TUNNEL, rand));
        }
        components.add((StructurePiece)new Piece(templateManager, surfacePos.func_177982_a(-6, 0, -7), TREE, rand));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation name;
        private final Rotation rotation;
        private final boolean hasKey;

        public Piece(TemplateManager templateManager, BlockPos pos, Segment segment, int level, Random rand) {
            super(SkiesStructures.POISON_DUNGEON.getPieceType(), 0);
            this.name = segment.getRandom(level, rand);
            this.hasKey = segment instanceof Intersection ? ((Intersection)segment).key : false;
            this.rotation = segment.rotation;
            this.field_186178_c = pos;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, BlockPos pos, ResourceLocation name, Random rand) {
            super(SkiesStructures.POISON_DUNGEON.getPieceType(), 0);
            this.name = name;
            this.hasKey = false;
            this.rotation = Rotation.NONE;
            this.field_186178_c = pos;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(SkiesStructures.POISON_DUNGEON.getPieceType(), nbt);
            this.name = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.hasKey = nbt.func_74767_n("HasKey");
            this.setupTemplate(templateManager);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.name.toString());
            nbt.func_74778_a("Rot", this.rotation.name());
            nbt.func_74757_a("HasKey", this.hasKey);
        }

        private void setupTemplate(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.name);
            BlockPos sizePos = templateManager.func_200219_b(this.name).func_186259_a();
            BlockPos centerPos = new BlockPos(sizePos.func_177958_n() / 2, 0, sizePos.func_177952_p() / 2);
            GelPlacementSettings settings = (GelPlacementSettings)new GelPlacementSettings().setMaintainWater(false).func_186220_a(this.rotation).func_207665_a(centerPos);
            settings.func_215222_a((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            settings.func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            settings.func_215222_a((StructureProcessor)new VinesProcessor());
            String key = this.name.toString();
            if (key.endsWith("_0")) {
                for (Block block : new Block[]{SkiesBlocks.poison_stone_slab, SkiesBlocks.poison_stone_stairs}) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(block, 0.5f, Blocks.field_150350_a));
                }
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.02f, SkiesBlocks.glowing_poison_stone));
            } else if (key.endsWith("_1")) {
                for (Block block : new Block[]{SkiesBlocks.poison_stone_slab, SkiesBlocks.poison_stone_stairs, SkiesBlocks.poison_stonebrick_slab, SkiesBlocks.poison_stonebrick_stairs}) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(block, 0.5f, Blocks.field_150350_a));
                }
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.02f, SkiesBlocks.glowing_poison_stone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.3f, SkiesBlocks.rough_poison_stonebrick));
            } else if (key.endsWith("_2")) {
                for (Block block : new Block[]{SkiesBlocks.poison_stone_slab, SkiesBlocks.poison_stone_stairs, SkiesBlocks.poison_stonebrick_slab, SkiesBlocks.poison_stonebrick_stairs}) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(block, 0.5f, Blocks.field_150350_a));
                }
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.02f, SkiesBlocks.glowing_poison_stone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.75f, SkiesBlocks.rough_poison_stonebrick));
            } else if (key.endsWith("_3")) {
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_150426_aN, 0.5f, SkiesBlocks.rough_poison_stonebrick));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stonebrick, 0.5f, SkiesBlocks.rough_poison_stonebrick));
                if (!key.contains("_chest")) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.spider_webbing, 0.8f, Blocks.field_150350_a));
                }
            } else if (key.endsWith("_4") && !key.contains("_chest")) {
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.spider_webbing, 0.8f, Blocks.field_150350_a));
            }
            if (this.name == TUNNEL) {
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stone, 0.8f, SkiesBlocks.lunar_cobblestone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stone, 0.5f, SkiesBlocks.poison_stone));
            }
            if (key.contains("_chest")) {
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196553_aF, 0.3f, Blocks.field_150350_a));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.spider_webbing, 0.3f, Blocks.field_150350_a));
            }
            if (key.contains("boss_room")) {
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stonebrick, 0.08f, SkiesBlocks.rough_poison_stonebrick));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.08f, SkiesBlocks.glowing_poison_stone));
            }
            this.func_186173_a(template, this.field_186178_c, (PlacementSettings)settings);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.contains("chest")) {
                BlockPos downPos = pos.func_177977_b();
                if (sbb.func_175898_b((Vector3i)downPos)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)downPos, (ResourceLocation)(this.hasKey ? SkiesLootProv.POISON_CHEST_KEY : SkiesLootProv.POISON_CHEST));
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.contains("spawner")) {
                worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
                if (worldIn.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
                    MobSpawnerTileEntity tile = (MobSpawnerTileEntity)worldIn.func_175625_s(pos);
                    tile.func_145881_a().func_200876_a(rand.nextBoolean() ? SkiesEntityTypes.VENOM_SPIDER : EntityType.field_200794_h);
                }
            }
            if ("keystone".equals(function)) {
                worldIn.func_180501_a(pos, SkiesBlocks.rough_poison_stonebrick.func_176223_P(), 3);
                TileEntity tileEntity = worldIn.func_175625_s(pos.func_177981_b(2));
                if (tileEntity instanceof KeystoneTileEntity.PoisonKeystoneTileEntity) {
                    KeystoneTileEntity.PoisonKeystoneTileEntity keystone = (KeystoneTileEntity.PoisonKeystoneTileEntity)tileEntity;
                    keystone.setTeleportOffset(new BlockPos(0, -1, 0).func_177967_a((Direction)worldIn.func_180495_p(pos.func_177981_b(2)).func_177229_b((Property)PoisonKeystoneBlock.FACING), -3));
                    keystone.setSpawnOffset(new BlockPos(0, -1, 0).func_177967_a((Direction)worldIn.func_180495_p(pos.func_177981_b(2)).func_177229_b((Property)PoisonKeystoneBlock.FACING), -12));
                }
            }
        }
    }

    public static class BossRoom
    extends Segment {
        public BossRoom(Rotation rotation) {
            this.rotation = rotation;
        }

        @Override
        protected void initPieces() {
            this.addPieces(4, "boss_room");
        }

        @Override
        public List<Direction> getConnections() {
            return ImmutableList.of((Object)this.rotation.func_185831_a(Direction.NORTH));
        }

        @Override
        public List<Direction> getSurroundingConnections(int x, int z, Floor floor) {
            ArrayList<Direction> directions = new ArrayList<Direction>();
            if (x > 0 && z < floor.size - 1 && floor.get(x - 1, z + 1) != null && floor.get(x - 1, z + 1).getConnections().contains(Direction.EAST)) {
                directions.add(Direction.WEST);
            }
            if (x < floor.size - 3 && z > 0 && floor.get(x + 3, z + 1) != null && floor.get(x + 3, z + 1).getConnections().contains(Direction.WEST)) {
                directions.add(Direction.EAST);
            }
            if (x < floor.size - 1 && z > 0 && floor.get(x + 1, z - 1) != null && floor.get(x + 1, z - 1).getConnections().contains(Direction.SOUTH)) {
                directions.add(Direction.NORTH);
            }
            if (x < floor.size - 1 && z < floor.size - 3 && floor.get(x + 1, z + 3) != null && floor.get(x + 1, z + 3).getConnections().contains(Direction.NORTH)) {
                directions.add(Direction.SOUTH);
            }
            return directions;
        }
    }

    public static abstract class Stairway
    extends Segment {
        public Stairway(Rotation rotation) {
            this.rotation = rotation;
        }

        public static class End
        extends Stairway {
            public End(Rotation rotation) {
                super(rotation);
            }

            @Override
            protected void initPieces() {
                for (int i = 0; i < 4; ++i) {
                    this.addPieces(i, "stairway/end_" + i);
                }
            }
        }

        public static class Cross
        extends Stairway {
            public Cross(Rotation rotation) {
                super(rotation);
            }

            @Override
            protected void initPieces() {
                for (int i = 0; i < 4; ++i) {
                    this.addPieces(i, "stairway/cross_" + i);
                }
            }
        }
    }

    public static class Hallway
    extends Segment {
        public Hallway(Rotation rotation) {
            this.rotation = rotation;
        }

        @Override
        protected void initPieces() {
            for (int i = 0; i < 4; ++i) {
                this.addPieces(i, "hallway/thin_" + i, "hallway/thick_" + i);
            }
            this.addPieces(4, "hallway/thick_4");
        }

        @Override
        public List<Direction> getConnections() {
            return ImmutableList.of((Object)this.rotation.func_185831_a(Direction.NORTH), (Object)this.rotation.func_185831_a(Direction.SOUTH));
        }
    }

    public static abstract class Intersection
    extends Segment {
        public boolean hasConnection = false;
        public boolean entry = false;
        public boolean chestRoom = false;
        public boolean key = false;
        public String type = "cross";

        @Override
        protected void initPieces() {
            String prefix = "intersection/" + (this.entry ? "entry/" : (this.chestRoom ? "room/" : "")) + this.type;
            for (int floor = 0; floor < 5; ++floor) {
                this.addPieces(floor, prefix + (this.chestRoom && floor < 4 ? "_chest_" : "_") + floor);
            }
        }

        public void setChest(boolean hasChest) {
            this.chestRoom = hasChest;
        }

        public void setKey(boolean key) {
            this.key = key;
        }

        public static class End
        extends Intersection {
            public End(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "end";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.func_185831_a(Direction.NORTH));
            }
        }

        public static class IShape
        extends Intersection {
            public IShape(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "i";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.func_185831_a(Direction.NORTH), (Object)this.rotation.func_185831_a(Direction.SOUTH));
            }
        }

        public static class LShape
        extends Intersection {
            public LShape(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "l";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.func_185831_a(Direction.NORTH), (Object)this.rotation.func_185831_a(Direction.WEST));
            }
        }

        public static class TShape
        extends Intersection {
            public TShape(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "t";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.func_185831_a(Direction.NORTH), (Object)this.rotation.func_185831_a(Direction.EAST), (Object)this.rotation.func_185831_a(Direction.WEST));
            }
        }

        public static class Cross
        extends Intersection {
            public Cross() {
                this(Rotation.NONE, false);
            }

            public Cross(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)Direction.WEST, (Object)Direction.EAST, (Object)Direction.NORTH, (Object)Direction.SOUTH);
            }
        }
    }

    public static abstract class Segment {
        public List<Direction> connections = new ArrayList<Direction>();
        public Map<Integer, List<ResourceLocation>> pieces = new HashMap<Integer, List<ResourceLocation>>();
        public Rotation rotation = Rotation.NONE;

        public ResourceLocation getRandom(int level, Random rand) {
            this.initPieces();
            if (this.pieces.containsKey(level)) {
                return this.pieces.get(level).get(rand.nextInt(this.pieces.get(level).size()));
            }
            if (this.pieces.entrySet().stream().findFirst().isPresent()) {
                Map.Entry entry = (Map.Entry)this.pieces.entrySet().stream().findFirst().get();
                return (ResourceLocation)((List)entry.getValue()).get(rand.nextInt(((List)entry.getValue()).size()));
            }
            BlueSkies.LOGGER.warn(String.format("Missing structure pieces for %s on floor %d", ((PoisonDungeonStructure)SkiesStructures.POISON_DUNGEON.getStructure()).getRegistryName(), level));
            return new ResourceLocation("empty");
        }

        public List<Direction> getConnections() {
            return ImmutableList.of();
        }

        public List<Direction> getSurroundingConnections(int x, int z, Floor floor) {
            ArrayList<Direction> directions = new ArrayList<Direction>();
            if (x > 0 && floor.get(x - 1, z) != null && floor.get(x - 1, z).getConnections().contains(Direction.EAST)) {
                directions.add(Direction.WEST);
            }
            if (x < floor.size - 1 && floor.get(x + 1, z) != null && floor.get(x + 1, z).getConnections().contains(Direction.WEST)) {
                directions.add(Direction.EAST);
            }
            if (z > 0 && floor.get(x, z - 1) != null && floor.get(x, z - 1).getConnections().contains(Direction.SOUTH)) {
                directions.add(Direction.NORTH);
            }
            if (z < floor.size - 1 && floor.get(x, z + 1) != null && floor.get(x, z + 1).getConnections().contains(Direction.NORTH)) {
                directions.add(Direction.SOUTH);
            }
            return directions;
        }

        protected void addPieces(int level, String ... names) {
            this.pieces.put(level, Arrays.asList(names).stream().map(s -> BlueSkies.locate("dungeons/everdawn/poison/" + s)).collect(Collectors.toList()));
        }

        public boolean equals(Segment segment) {
            return this.rotation == segment.rotation && this.getClass() == segment.getClass();
        }

        protected abstract void initPieces();
    }

    public static class BossFloor
    extends Floor {
        public BossFloor(int level, BlockPos worldPos, Pair<Integer, Integer> center, Random rand) {
            super(level, worldPos, center, rand);
        }

        @Override
        public void init(Pair<Integer, Integer> center) {
            int middle = 8;
            Pair bossPos = Pair.of((Object)middle, (Object)middle);
            if ((Integer)center.getFirst() >= (Integer)bossPos.getFirst() - 3 && (Integer)center.getFirst() <= (Integer)bossPos.getFirst() + 3 && (Integer)center.getSecond() >= (Integer)bossPos.getSecond() - 3 && (Integer)center.getSecond() <= (Integer)bossPos.getSecond() + 3) {
                bossPos = Pair.of((Object)(middle + 5), (Object)(middle + 5));
            }
            this.set((Integer)center.getFirst(), (Integer)center.getSecond(), new Intersection.Cross());
            this.connect((Integer)center.getFirst(), (Integer)center.getSecond(), (Integer)bossPos.getFirst() + 1, (Integer)bossPos.getSecond() + 1);
            for (int x = ((Integer)bossPos.getFirst()).intValue(); x < (Integer)bossPos.getFirst() + 3; ++x) {
                for (int z = ((Integer)bossPos.getSecond()).intValue(); z < (Integer)bossPos.getSecond() + 3; ++z) {
                    this.set(x, z, null);
                }
            }
            this.set((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond(), new BossRoom(Rotation.NONE));
            List<Direction> conns = this.get((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond()).getSurroundingConnections((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond(), this);
            Rotation rot = Rotation.NONE;
            if (conns.contains(Direction.SOUTH)) {
                rot = Rotation.CLOCKWISE_180;
            } else if (conns.contains(Direction.EAST)) {
                rot = Rotation.CLOCKWISE_90;
            } else if (conns.contains(Direction.WEST)) {
                rot = Rotation.COUNTERCLOCKWISE_90;
            }
            this.set((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond(), new BossRoom(rot));
            this.updateIntersections();
            this.changeToEntry(center);
        }

        @Override
        public void connect(int x, int z, int x1, int z1) {
            if (Math.abs(x - x1) < Math.abs(z - z1)) {
                super.connect(x, z, x1, z);
                super.connect(x1, z, x1, z1);
            } else {
                super.connect(x, z, x, z1);
                super.connect(x, z1, x1, z1);
            }
        }
    }

    public static class Floor {
        public List<List<Segment>> map = new ArrayList<List<Segment>>();
        public final BlockPos worldPos;
        public Pair<Integer, Integer> exitPair = Pair.of((Object)8, (Object)8);
        public final Random rand;
        public final int level;
        public final int size = 16;

        public Floor(int level, BlockPos worldPos, Pair<Integer, Integer> center, Random rand) {
            this.level = level;
            this.worldPos = worldPos;
            this.rand = rand;
            for (int x = 0; x < 16; ++x) {
                this.map.add(new ArrayList());
                for (int z = 0; z < 16; ++z) {
                    this.map.get(x).add(null);
                }
            }
            this.init(center);
        }

        public void init(Pair<Integer, Integer> center) {
            int i;
            this.set((Integer)center.getFirst(), (Integer)center.getSecond(), new Intersection.Cross());
            ArrayList<Pair> firstBranches = new ArrayList<Pair>();
            for (i = 0; i < this.rand.nextInt(2) + 3; ++i) {
                firstBranches.add(Pair.of((Object)this.rand.nextInt(16), (Object)this.rand.nextInt(16)));
            }
            firstBranches.forEach(pair -> this.connect((Integer)center.getFirst(), (Integer)center.getSecond(), (Integer)pair.getFirst(), (Integer)pair.getSecond()));
            for (i = 0; i < this.rand.nextInt(5) + 6; ++i) {
                Pair<Integer, Integer> from = this.getRandomSegmentPos();
                Pair<Integer, Integer> to = this.randomPair();
                this.connect((Integer)from.getFirst(), (Integer)from.getSecond(), (Integer)to.getFirst(), (Integer)to.getSecond());
            }
            this.updateIntersections();
            this.changeToEntry(center);
            ArrayList<Pair> deadEnds = new ArrayList<Pair>();
            ArrayList<Pair> crosses = new ArrayList<Pair>();
            ArrayList<Pair> anyOfThem = new ArrayList<Pair>();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Segment seg = this.get(x, z);
                    if (seg == null || !(seg instanceof Intersection)) continue;
                    if (!Pair.of((Object)x, (Object)z).equals(center)) {
                        if (seg instanceof Intersection.End) {
                            deadEnds.add(Pair.of((Object)x, (Object)z));
                            continue;
                        }
                        if (!(seg instanceof Intersection.Cross)) continue;
                        crosses.add(Pair.of((Object)x, (Object)z));
                        continue;
                    }
                    anyOfThem.add(Pair.of((Object)x, (Object)z));
                }
            }
            if (!deadEnds.isEmpty()) {
                this.exitPair = (Pair)deadEnds.get(this.rand.nextInt(deadEnds.size()));
                this.set((Integer)this.exitPair.getFirst(), (Integer)this.exitPair.getSecond(), new Stairway.End(this.get((int)((Integer)this.exitPair.getFirst()).intValue(), (int)((Integer)this.exitPair.getSecond()).intValue()).rotation));
            } else {
                this.exitPair = !crosses.isEmpty() ? (Pair)crosses.get(this.rand.nextInt(crosses.size())) : (Pair)anyOfThem.get(this.rand.nextInt(anyOfThem.size()));
                this.set((Integer)this.exitPair.getFirst(), (Integer)this.exitPair.getSecond(), new Stairway.Cross(this.get((int)((Integer)this.exitPair.getFirst()).intValue(), (int)((Integer)this.exitPair.getSecond()).intValue()).rotation));
            }
            ArrayList<Pair> intersections = new ArrayList<Pair>();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Segment checking = this.get(x, z);
                    if (checking == null || !(checking instanceof Intersection) || ((Intersection)checking).entry) continue;
                    intersections.add(Pair.of((Object)x, (Object)z));
                }
            }
            intersections.forEach(p -> {
                if (this.rand.nextFloat() < 0.4f) {
                    ((Intersection)this.get((Pair<Integer, Integer>)p)).setChest(true);
                }
            });
            Intersection keyRoom = (Intersection)this.get((Pair<Integer, Integer>)((Pair)intersections.get(this.rand.nextInt(intersections.size()))));
            keyRoom.setKey(true);
            keyRoom.setChest(true);
        }

        public void changeToEntry(Pair<Integer, Integer> position) {
            Segment segOld = this.get((Integer)position.getFirst(), (Integer)position.getSecond());
            Intersection segNew = new Intersection.Cross(segOld.rotation, true);
            if (segOld != null) {
                if (segOld instanceof Intersection.End) {
                    segNew = new Intersection.End(segOld.rotation, true);
                } else if (segOld instanceof Intersection.IShape) {
                    segNew = new Intersection.IShape(segOld.rotation, true);
                } else if (segOld instanceof Intersection.LShape) {
                    segNew = new Intersection.LShape(segOld.rotation, true);
                } else if (segOld instanceof Intersection.TShape) {
                    segNew = new Intersection.TShape(segOld.rotation, true);
                }
            }
            this.set((Integer)position.getFirst(), (Integer)position.getSecond(), segNew);
        }

        public void updateIntersections() {
            for (int x = 0; x < 16; ++x) {
                block6: for (int z = 0; z < 16; ++z) {
                    if (this.get(x, z) == null) continue;
                    if (this.get(x, z) instanceof Intersection) {
                        List<Direction> conns = ((Intersection)this.get(x, z)).getSurroundingConnections(x, z, this);
                        switch (conns.size()) {
                            case 1: {
                                Rotation rot = Rotation.NONE;
                                if (conns.contains(Direction.EAST)) {
                                    rot = Rotation.CLOCKWISE_90;
                                } else if (conns.contains(Direction.SOUTH)) {
                                    rot = Rotation.CLOCKWISE_180;
                                } else if (conns.contains(Direction.WEST)) {
                                    rot = Rotation.COUNTERCLOCKWISE_90;
                                }
                                this.set(x, z, new Intersection.End(rot, false));
                                break;
                            }
                            case 2: {
                                if (conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && !conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                    this.set(x, z, new Intersection.IShape(this.rand.nextBoolean() ? Rotation.NONE : Rotation.CLOCKWISE_180, false));
                                } else if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                    this.set(x, z, new Intersection.IShape(this.rand.nextBoolean() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90, false));
                                }
                                for (Rotation rot : Rotation.values()) {
                                    if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)rot.func_185831_a(Direction.NORTH), (Object)rot.func_185831_a(Direction.WEST)))) continue;
                                    this.set(x, z, new Intersection.LShape(rot, false));
                                }
                                continue block6;
                            }
                            case 3: {
                                Rotation rot = Rotation.NONE;
                                if (!conns.contains(Direction.WEST)) {
                                    rot = Rotation.CLOCKWISE_90;
                                } else if (!conns.contains(Direction.NORTH)) {
                                    rot = Rotation.CLOCKWISE_180;
                                } else if (!conns.contains(Direction.EAST)) {
                                    rot = Rotation.COUNTERCLOCKWISE_90;
                                }
                                this.set(x, z, new Intersection.TShape(rot, false));
                                break;
                            }
                        }
                        continue;
                    }
                    if (!(this.get(x, z) instanceof Hallway)) continue;
                    this.set(x, z, new Hallway(this.get((int)x, (int)z).rotation.func_185830_a(this.rand.nextBoolean() ? Rotation.NONE : Rotation.CLOCKWISE_180)));
                }
            }
        }

        public Pair<Integer, Integer> getRandomSegmentPos() {
            Segment segment = null;
            Pair<Integer, Integer> pair = Pair.of((Object)8, (Object)8);
            while (segment == null || segment != null && segment instanceof BossRoom) {
                pair = this.randomPair();
                segment = this.get(pair);
            }
            return pair;
        }

        public Pair<Integer, Integer> randomPair() {
            return Pair.of((Object)this.rand.nextInt(16), (Object)this.rand.nextInt(16));
        }

        @Nullable
        public Segment get(int x, int z) {
            return this.map.get(x).get(z);
        }

        @Nullable
        public Segment get(Pair<Integer, Integer> pair) {
            return this.get((Integer)pair.getFirst(), (Integer)pair.getSecond());
        }

        public void set(int x, int z, Segment segment) {
            this.map.get(x).set(z, segment);
        }

        public void connect(int x, int z, int x1, int z1) {
            this.set(x, z, new Intersection.Cross());
            if (this.get(x1, z1) == null || !(this.get(x1, z1) instanceof BossRoom)) {
                this.set(x1, z1, new Intersection.Cross());
            }
            if (this.rand.nextBoolean()) {
                int placements;
                for (placements = 0; x != x1 && placements < 50; ++placements) {
                    if (x < x1) {
                        ++x;
                    }
                    if (x > x1) {
                        --x;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.CLOCKWISE_90));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.CLOCKWISE_90))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
                if (x == x1) {
                    this.set(x, z, new Intersection.Cross());
                }
                for (placements = 0; z != z1 && placements < 50; ++placements) {
                    if (z < z1) {
                        ++z;
                    }
                    if (z > z1) {
                        --z;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.NONE));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.NONE))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
            } else {
                int placements;
                for (placements = 0; z != z1 && placements < 50; ++placements) {
                    if (z < z1) {
                        ++z;
                    }
                    if (z > z1) {
                        --z;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.NONE));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.NONE))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
                if (z == z1) {
                    this.set(x, z, new Intersection.Cross());
                }
                for (placements = 0; x != x1 && placements < 50; ++placements) {
                    if (x < x1) {
                        ++x;
                    }
                    if (x > x1) {
                        --x;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.CLOCKWISE_90));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.CLOCKWISE_90))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
            }
        }

        public void addPieces(List<StructurePiece> components, TemplateManager templateManager) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Segment seg = this.get(x, z);
                    if (seg == null) continue;
                    int yOffset = seg instanceof Stairway ? -5 : 0;
                    int xOffset = seg instanceof BossRoom ? -2 : 0;
                    components.add((StructurePiece)new Piece(templateManager, new BlockPos(this.worldPos.func_177958_n() + (x - 8) * 9 + xOffset, this.worldPos.func_177956_o() + yOffset, this.worldPos.func_177952_p() + (z - 8) * 9), seg, this.level, this.rand));
                }
            }
        }
    }
}

