/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features.cave;

import com.legacy.blue_skies.blocks.natural.SkyDripstoneBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LunarLavaSpireFeature
extends AbstractCaveFeature<NoFeatureConfig> {
    public LunarLavaSpireFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable newPos = pos.func_239590_i_();
        int xSpread = 7;
        int zSpread = 7;
        for (int j = 0; j < 10; ++j) {
            newPos.func_239621_a_((Vector3i)pos, rand.nextInt(xSpread + 2) - rand.nextInt(xSpread + 2), 0, rand.nextInt(zSpread + 2) - rand.nextInt(zSpread + 2));
            while (world.func_204610_c((BlockPos)newPos).func_206884_a((ITag)FluidTags.field_206960_b) && newPos.func_177956_o() < world.func_181545_F()) {
                world.func_180501_a((BlockPos)newPos, SkiesBlocks.lunar_stone.func_176223_P(), 2);
                newPos.func_189536_c(Direction.UP);
            }
            if (!world.func_175623_d((BlockPos)newPos)) continue;
            int height = j == 0 ? 6 : 2 + rand.nextInt(3);
            for (int i = 0; i < height; ++i) {
                BlockState state = SkiesBlocks.lunar_stone.func_176223_P();
                if (i == height - 1) {
                    state = (BlockState)SkiesBlocks.lunar_dripstone.func_176223_P().func_206870_a(SkyDripstoneBlock.SECTION, (Comparable)((Object)SkyDripstoneBlock.Section.TIP));
                }
                if (i == height - 2) {
                    state = (BlockState)SkiesBlocks.lunar_dripstone.func_176223_P().func_206870_a(SkyDripstoneBlock.SECTION, (Comparable)((Object)SkyDripstoneBlock.Section.MIDDLE));
                }
                if (i == height - 3) {
                    state = (BlockState)SkiesBlocks.lunar_dripstone.func_176223_P().func_206870_a(SkyDripstoneBlock.SECTION, (Comparable)((Object)SkyDripstoneBlock.Section.BASE));
                }
                world.func_180501_a(newPos.func_177981_b(i), state, 2);
            }
        }
        return true;
    }

    @Override
    public boolean isValidPos(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        return world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206960_b) && !world.func_204610_c(pos.func_177977_b()).func_206884_a((ITag)FluidTags.field_206960_b);
    }

    @Override
    public int getMaxHeight(NoFeatureConfig config) {
        return 10;
    }
}

