/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class LargeDuskTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.dusk_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.dusk_leaves.func_176223_P();

    public LargeDuskTreeFeature(Codec<BaseTreeFeatureConfig> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int z1;
        int x1;
        int z;
        int x;
        int height = rand.nextInt(5) + 16;
        if (!this.isAreaOk(world, pos, height, 2, height - 2, 3)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x2 = 0; x2 < 2; ++x2) {
                for (int z2 = 0; z2 < 2; ++z2) {
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x2, y, z2), LOG, bounds);
                }
            }
        }
        for (x = -4; x <= 4; ++x) {
            for (z = -4; z <= 4; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.func_177982_a(x > 0 ? x - 1 : x, height - 2, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 >= 4 && z1 == 4 && x1 == 4) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF, bounds);
                if (!((double)rand.nextFloat() < 0.3)) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos.func_177977_b(), LEAF, bounds);
            }
        }
        for (x = -4; x <= 4; ++x) {
            for (z = -4; z <= 4; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.func_177982_a(x > 0 ? x - 1 : x, height - 1, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 + x1 >= 7) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF, bounds);
            }
        }
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.func_177982_a(x > 0 ? x - 1 : x, height, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 == 3 && x1 == 3) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF, bounds);
            }
        }
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.func_177982_a(rand.nextInt(2), rand.nextInt(5) + 6, -1), bounds, Direction.NORTH);
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.func_177982_a(2, rand.nextInt(5) + 6, rand.nextInt(2)), bounds, Direction.EAST);
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.func_177982_a(rand.nextInt(2), rand.nextInt(5) + 6, 2), bounds, Direction.SOUTH);
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.func_177982_a(-1, rand.nextInt(5) + 6, rand.nextInt(2)), bounds, Direction.WEST);
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if (!rand.nextBoolean() || !((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, 0, z), LOG, bounds);
                if (!rand.nextBoolean()) continue;
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, 1, z), LOG, bounds);
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, 2, z), LOG, bounds);
                if (!rand.nextBoolean()) continue;
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, 3, z), LOG, bounds);
            }
        }
        if (this.natural) {
            AbstractSkyTreeFeature.placeVines(world, pos, rand, 13, height, 4, 6, 0.05f, SkiesBlocks.dusk_vine, (Set<Block>)ImmutableSet.of((Object)((Object)SkiesBlocks.dusk_leaves)));
        }
        return true;
    }

    protected void setLowerBranch(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, Random rand, ISeedReader world, BlockPos pos, MutableBoundingBox bounds, Direction direction) {
        this.setBlockIfOk(changedLogs, world, pos, (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), bounds);
        this.setBlockIfOk(changedLogs, world, pos.func_177967_a(direction, 1), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), bounds);
        this.setBlockIfOk(changedLogs, world, pos.func_177967_a(direction, 2).func_177984_a(), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), bounds);
        this.setBlockIfOk(changedLogs, world, pos.func_177967_a(direction, 3).func_177984_a(), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), bounds);
        this.setBlockIfOk(changedLogs, world, pos.func_177967_a(direction, 4).func_177981_b(2), LOG, bounds);
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                int x1 = Math.abs(x);
                int z1 = Math.abs(z);
                this.setBlockIfOk(changedLeaves, world, pos.func_177967_a(direction, 4).func_177982_a(x, 2, z), LEAF, bounds);
                if (z1 != 2 || x1 != 2) {
                    this.setBlockIfOk(changedLeaves, world, pos.func_177967_a(direction, 4).func_177982_a(x, 3, z), LEAF, bounds);
                }
                if (!((double)rand.nextFloat() < 0.3)) continue;
                this.setBlockIfOk(changedLeaves, world, pos.func_177967_a(direction, 4).func_177982_a(x, 1, z), LEAF, bounds);
            }
        }
    }

    @Override
    public boolean isValidGround(ISeedReader world, BlockState state, BlockPos pos) {
        if (this.natural) {
            return super.isValidGround(world, state, pos) && state.func_177230_c() != SkiesBlocks.coarse_lunar_dirt;
        }
        return super.isValidGround(world, state, pos);
    }
}

