/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class DuskTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.dusk_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.dusk_leaves.func_176223_P();
    protected int minTreeHeight;

    public DuskTreeFeature(Codec<BaseTreeFeatureConfig> config, int minTreeHeightIn) {
        super(config, true);
        this.minTreeHeight = minTreeHeightIn;
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int height = rand.nextInt(3) + this.minTreeHeight;
        if (!this.isAreaOk(world, pos, height, 1, height - 3, 7)) {
            return false;
        }
        this.setLeafCanopy(changedLeaves, world, rand, pos.func_177982_a(0, height - 2, 0), bounds);
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.func_177981_b(y), LOG, bounds);
        }
        this.setBranches(changedLogs, world, rand, pos, bounds, height);
        return true;
    }

    protected void setBranches(Set<BlockPos> changedLogs, ISeedReader world, Random rand, BlockPos pos, MutableBoundingBox bounds, int height) {
        int y = height - 3;
        if (rand.nextBoolean()) {
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(1, y, 0), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(-1, y, 0), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(2, y + 1, 0), LOG, bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(-2, y + 1, 0), LOG, bounds);
        } else {
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, y, 1), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, y, -1), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, y + 1, 2), LOG, bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, y + 1, -2), LOG, bounds);
        }
    }

    protected void setLeafCanopy(Set<BlockPos> changedLeaves, ISeedReader world, Random rand, BlockPos pos, MutableBoundingBox bounds) {
        int z;
        int x;
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (Math.abs(x) == 3 && Math.abs(z) == 3 || rand.nextInt(3) != 0) continue;
                this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, 0, z), LEAF, bounds);
            }
        }
        pos = pos.func_177984_a();
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (Math.abs(x) == 3 && Math.abs(z) == 3) continue;
                this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, 0, z), LEAF, bounds);
            }
        }
        for (int longSide = -4; longSide <= 4; ++longSide) {
            for (int shortSide = -1; shortSide <= 1; ++shortSide) {
                if (Math.abs(longSide) != 4) continue;
                this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(longSide, 0, shortSide), LEAF, bounds);
                this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(shortSide, 0, longSide), LEAF, bounds);
            }
        }
        pos = pos.func_177984_a();
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, 0, z), LEAF, bounds);
            }
        }
    }
}

