/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class CrystalizedTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.crystallized_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.crystallized_leaves.func_176223_P();

    public CrystalizedTreeFeature(Codec<BaseTreeFeatureConfig> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int height = rand.nextInt(3) + 6;
        if (!this.isAreaOk(world, pos, height, 1, 3, 7)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.func_177981_b(y), LOG, bounds);
        }
        Direction noBranch = DirectionUtil.randHorizontal(rand);
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            if (dir == noBranch) continue;
            BlockPos branchPos = pos.func_177981_b(3 + rand.nextInt(3));
            int maxBranchLength = rand.nextInt(2) + 4;
            for (int branchLength = 0; branchLength < maxBranchLength; ++branchLength) {
                branchPos = branchPos.func_177984_a();
                if (branchLength < maxBranchLength / 2) {
                    branchPos = branchPos.func_177972_a(dir);
                }
                this.setBlockIfOk(changedLogs, world, branchPos, LOG, bounds);
                if (branchLength != maxBranchLength - 1) continue;
                this.setBlockIfOk(changedLeaves, world, branchPos.func_177984_a(), LEAF, bounds);
            }
        }
        int xzSize = 4;
        for (int x = -xzSize; x <= xzSize; ++x) {
            for (int z = -xzSize; z <= xzSize; ++z) {
                for (int y = 5; y < height + 6; ++y) {
                    BlockPos logPos = pos.func_177982_a(x, y, z);
                    if (world.func_180495_p(logPos).func_177230_c() != LOG.func_177230_c()) continue;
                    for (Direction dir : Direction.values()) {
                        if (!rand.nextBoolean()) continue;
                        BlockPos leafPos = logPos.func_177972_a(dir);
                        this.setBlockIfOk(changedLeaves, world, leafPos, LEAF, bounds);
                        for (Direction leafDir : Direction.values()) {
                            this.setBlockIfOk(changedLeaves, world, leafPos.func_177972_a(leafDir), LEAF, bounds);
                            if (!rand.nextBoolean()) continue;
                            this.setBlockIfOk(changedLeaves, world, leafPos.func_177972_a(leafDir).func_177972_a(leafDir), LEAF, bounds);
                        }
                    }
                }
            }
        }
        if (this.natural) {
            for (int attempts = 0; attempts < 8; ++attempts) {
                BlockPos flowerPos = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(4) - rand.nextInt(4));
                this.setBlockIfOk(null, world, flowerPos, SkiesBlocks.crystal_flower.func_176223_P(), bounds);
            }
        }
        return true;
    }

    @Override
    public boolean isValidGround(ISeedReader world, BlockState groundState, BlockPos pos) {
        return groundState.func_177230_c() == SkiesBlocks.crystal_sand;
    }
}

