/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.bunker;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BunkerStructure
extends GelJigsawStructure {
    public BunkerStructure(Codec<VillageConfig> config) {
        super(config, 0, true, true);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPosIn, VillageConfig config) {
        ChunkPos chunkPos = this.func_236392_a_(this.getSeparationSettings(), seed, sharedSeedRand, chunkPosX, chunkPosZ);
        if (chunkPos.field_77276_a == chunkPosX && chunkPos.field_77275_b == chunkPosZ) {
            sharedSeedRand.func_202427_a(seed, chunkPosX, chunkPosZ, this.getSeed());
            int height = BunkerStructure.getYValue(chunkGen, chunkPos.field_77276_a * 16, chunkPos.field_77275_b * 16);
            return sharedSeedRand.nextDouble() < this.getProbability() && height <= 80 && height >= 60;
        }
        return false;
    }

    public double getProbability() {
        return 0.85;
    }

    public int getSpacing() {
        return 18;
    }

    public int getOffset() {
        return this.getSpacing() / 3;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERBRIGHT_ID);
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static int getYValue(ChunkGenerator chunkGen, int x, int z) {
        return chunkGen.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG);
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox bounds) {
            if (key.equals("spawner")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
                if (worldIn.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
                    MobSpawnerTileEntity tile = (MobSpawnerTileEntity)worldIn.func_175625_s(pos);
                    tile.func_145881_a().func_200876_a(SkiesEntityTypes.ARMORED_FROST_SPIRIT);
                }
            } else if (key.startsWith("chest") && key.contains("-")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                String facing = key.split("-")[1];
                boolean isRare = (double)rand.nextFloat() < 0.25;
                this.func_191080_a(worldIn, bounds, rand, pos, isRare ? SkiesLootProv.BUNKER_RARE : SkiesLootProv.BUNKER, (BlockState)(isRare ? SkiesBlocks.starlit_chest : SkiesBlocks.bluebright_chest).func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.func_176739_a((String)facing)));
            }
        }

        public IStructurePieceType func_214807_k() {
            return SkiesStructures.BUNKER.getPieceType();
        }
    }
}

