/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.BaseLargeMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class SnowcapMushroomFeature
extends BaseLargeMushroomFeature {
    private static final BlockState STEM = SkiesBlocks.snowcap_mushroom_stem.func_176223_P();
    private static final BlockState CAP = SkiesBlocks.snowcap_mushroom_block.func_176223_P();

    public SnowcapMushroomFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedMushrooms, MutableBoundingBox bounds) {
        Direction[] directionArray;
        int bottomOffset;
        int capWidth = rand.nextBoolean() ? 3 : 4;
        int height = 10 + rand.nextInt(4);
        if (!this.isAreaOk(world, pos, height, 1, height, capWidth * 2 + 1)) {
            return false;
        }
        if (world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            for (bottomOffset = 0; bottomOffset < 2 && world.func_180495_p(pos.func_177979_c(bottomOffset + 1)).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a); ++bottomOffset) {
            }
        }
        for (int y = -bottomOffset; y < height; ++y) {
            this.setBlockIfOk(changedMushrooms, world, pos.func_177981_b(y), STEM, bounds);
        }
        Direction[] y = DirectionUtil.HORIZONTAL;
        int n = y.length;
        for (int i = 0; i < n; ++i) {
            BlockState lowerState;
            Direction dir = y[i];
            BlockPos offsetPos = pos.func_177972_a(dir).func_177979_c(bottomOffset);
            this.setBlockIfOk(changedMushrooms, world, offsetPos, STEM, bounds);
            if (rand.nextBoolean()) {
                this.setBlockIfOk(changedMushrooms, world, offsetPos.func_177984_a(), STEM, bounds);
            }
            if (!(lowerState = world.func_180495_p(offsetPos.func_177977_b())).func_185904_a().func_76222_j() && !(lowerState.func_177230_c() instanceof BushBlock)) continue;
            this.setBlock(changedMushrooms, world, offsetPos.func_177977_b(), STEM, bounds);
        }
        for (int x = -capWidth; x <= capWidth; ++x) {
            for (int z = -capWidth; z <= capWidth; ++z) {
                if (Math.abs(x) == capWidth && Math.abs(x) == Math.abs(z)) continue;
                this.setBlockIfOk(changedMushrooms, world, pos.func_177982_a(x, height, z), (BlockState)CAP.func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)), bounds);
            }
        }
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            for (int i = -capWidth; i <= capWidth; ++i) {
                BlockState state = (BlockState)((BlockState)CAP.func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SixWayBlock.field_196491_B.get(dir.func_176734_d().func_176746_e()), (Comparable)Boolean.valueOf(false));
                if (Math.abs(i) == capWidth - 1) {
                    state = (BlockState)((BlockState)state.func_206870_a((Property)SixWayBlock.field_196491_B.get(dir), (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SixWayBlock.field_196491_B.get(dir.func_176734_d()), (Comparable)Boolean.valueOf(false));
                }
                this.setBlockIfOk(changedMushrooms, world, pos.func_177967_a(dir, i).func_177967_a(dir.func_176746_e(), i > -capWidth + 1 && i < capWidth - 1 ? capWidth + 1 : capWidth).func_177981_b(height - 1), state, bounds);
            }
        }
        Direction.AxisDirection lowerSide = rand.nextBoolean() ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        int baseBranchHeight = height - 5 - rand.nextInt(2);
        if (rand.nextBoolean()) {
            Direction[] directionArray2 = new Direction[2];
            directionArray2[0] = Direction.NORTH;
            directionArray = directionArray2;
            directionArray2[1] = Direction.SOUTH;
        } else {
            Direction[] directionArray3 = new Direction[2];
            directionArray3[0] = Direction.EAST;
            directionArray = directionArray3;
            directionArray3[1] = Direction.WEST;
        }
        for (Direction dir : directionArray) {
            int y2 = baseBranchHeight;
            if (dir.func_176743_c() == lowerSide) {
                y2 = Math.max(y2 - rand.nextInt(2) - 2, 2);
            }
            int branchLength = 2;
            for (int i = 1; i <= branchLength; ++i) {
                this.setBlockIfOk(changedMushrooms, world, pos.func_177967_a(dir, i).func_177981_b(y2), STEM, bounds);
            }
            BlockPos branchCapPos = pos.func_177967_a(dir, rand.nextBoolean() ? branchLength : branchLength + 1);
            this.setBlockIfOk(changedMushrooms, world, branchCapPos.func_177981_b(y2 + 1), STEM, bounds);
            int branchCapWidth = 1;
            for (int x = -branchCapWidth; x <= branchCapWidth; ++x) {
                for (int z = -branchCapWidth; z <= branchCapWidth; ++z) {
                    this.setBlockIfOk(changedMushrooms, world, branchCapPos.func_177982_a(x, y2 + 2, z), (BlockState)CAP.func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)), bounds);
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidGround(ISeedReader world, BlockState state, BlockPos pos) {
        if (!super.isValidGround(world, state, pos)) {
            if (world.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
                int depth;
                for (depth = 0; depth <= 2 && world.func_180495_p(pos.func_177979_c(depth)).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a); ++depth) {
                }
                if (depth <= 2) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

