/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class OceanSpikeFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState SAND = SkiesBlocks.midnight_sand.func_176223_P();
    private static final BlockState SANDSTONE = SkiesBlocks.midnight_sandstone.func_176223_P();

    public OceanSpikeFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        pos = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos);
        if (rand.nextBoolean()) {
            int centerHeight = rand.nextInt(2) + 7;
            if (pos.func_177956_o() + centerHeight < world.func_181545_F() - 1) {
                for (int y = 0; y < centerHeight; ++y) {
                    int i;
                    this.setBlock((IWorld)world, pos.func_177981_b(y), y == centerHeight - 1);
                    for (i = -1; i <= 1 && (y < 4 || y < 5 && rand.nextBoolean()); i += 2) {
                        this.setBlock((IWorld)world, pos.func_177982_a(i, y, 0), y >= 3);
                        this.setBlock((IWorld)world, pos.func_177982_a(0, y, i), y >= 3);
                    }
                    for (i = -1; i <= 1 && (y < 2 || y < 3 && rand.nextBoolean()); i += 2) {
                        this.setBlock((IWorld)world, pos.func_177982_a(i, y, i), y >= 2);
                        this.setBlock((IWorld)world, pos.func_177982_a(-i, y, i), y >= 2);
                    }
                    for (i = -2; i <= 2 && y < 1; i += 4) {
                        this.setBlock((IWorld)world, pos.func_177982_a(i, y, 0), true);
                        this.setBlock((IWorld)world, pos.func_177982_a(0, y, i), true);
                    }
                }
                int maxXZ = 2;
                for (int x = -maxXZ; x <= maxXZ; ++x) {
                    for (int z = -maxXZ; z <= maxXZ; ++z) {
                        for (int y = -1; y >= -2; --y) {
                            if (Math.abs(x) == maxXZ && Math.abs(x) == Math.abs(z)) continue;
                            this.setBlock((IWorld)world, pos.func_177982_a(x, y, z), true);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        if (rand.nextBoolean()) {
            int y;
            for (y = 0; y <= 2; ++y) {
                this.setBlock((IWorld)world, pos.func_177981_b(y), y >= 2);
            }
            for (y = 0; y >= -2; --y) {
                for (int xz = -1; xz <= 1; xz += 2) {
                    this.setBlock((IWorld)world, pos.func_177982_a(xz, y, 0), false);
                    this.setBlock((IWorld)world, pos.func_177982_a(0, y, xz), false);
                }
            }
            boolean x = rand.nextBoolean();
            boolean positive = rand.nextBoolean();
            this.setBlock((IWorld)world, pos.func_177982_a(x ? 1 * (positive ? 1 : -1) : 0, 1, x ? 0 : 1 * (positive ? 1 : -1)), true);
            return true;
        }
        return false;
    }

    private void setBlock(IWorld world, BlockPos pos, boolean sand) {
        world.func_180501_a(pos, sand ? SAND : SANDSTONE, 2);
    }
}

