/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.biome.provider.layer;

import com.legacy.blue_skies.world.everbright.biome.provider.layer.EverbrightBiomeLayer;
import com.legacy.blue_skies.world.everbright.biome.provider.layer.EverbrightOceanLayer;
import com.legacy.blue_skies.world.everbright.biome.provider.layer.EverbrightShoreLayer;
import com.legacy.blue_skies.world.everbright.biome.provider.layer.MixEverbrightOceansLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationNoiseLayer;
import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class EverbrightLayer {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = layer;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> setupLayers(int biomeSize, int riverSize, LongFunction<C> contextFactory) {
        IAreaFactory<T> baseLayer = IslandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        baseLayer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), (IAreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2001L), (IAreaFactory)baseLayer);
        IAreaFactory<T> oceanLayer = EverbrightOceanLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(2L));
        oceanLayer = EverbrightLayer.repeat(2001L, (IAreaTransformer1)ZoomLayer.NORMAL, oceanLayer, 6, contextFactory);
        baseLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2002L), (IAreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2003L), (IAreaFactory)baseLayer);
        baseLayer = EverbrightLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        IAreaFactory baseZoom1 = EverbrightLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        IAreaFactory everbrightBiomeLayer = new EverbrightBiomeLayer().func_202713_a((IExtendedNoiseRandom)contextFactory.apply(200L), baseLayer);
        baseZoom1 = EverbrightLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseZoom1, 2, contextFactory);
        baseZoom1 = EverbrightLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseZoom1, riverSize, contextFactory);
        baseZoom1 = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), baseZoom1);
        for (int k = 0; k < biomeSize; ++k) {
            everbrightBiomeLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000 + k), everbrightBiomeLayer);
            if (k != 1 && biomeSize != 1) continue;
            everbrightBiomeLayer = EverbrightShoreLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), everbrightBiomeLayer);
        }
        everbrightBiomeLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), everbrightBiomeLayer);
        everbrightBiomeLayer = MixEverbrightOceansLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), everbrightBiomeLayer, oceanLayer);
        IAreaFactory mutationLayer = BiomeMutationNoiseLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(2L));
        everbrightBiomeLayer = BiomeMutationLayer.LARGE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), everbrightBiomeLayer, EverbrightLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, mutationLayer, 2, contextFactory));
        everbrightBiomeLayer = BiomeMutationLayer.SMALL.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), everbrightBiomeLayer, mutationLayer);
        return everbrightBiomeLayer;
    }

    public static Layer build(long seed, int biomeSize, int riverSize) {
        IAreaFactory layerFactory = EverbrightLayer.setupLayers(biomeSize, riverSize, seedModifier -> new LazyAreaLayerContext(25, seed, seedModifier));
        return new Layer(layerFactory);
    }
}

