/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.tile_entity;

import com.legacy.blue_skies.client.gui.container.SnowcapOvenContainer;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.FreezingRecipe;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesTileEntityTypes;
import com.legacy.blue_skies.util.LogicUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SnowcapOvenTileEntity
extends AbstractFurnaceTileEntity {
    public SnowcapOvenTileEntity() {
        super(SkiesTileEntityTypes.SNOWCAP_OVEN, IRecipeType.field_222150_b);
        this.field_214012_a = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent(SkiesBlocks.snowcap_oven.func_149739_a());
    }

    protected SnowcapOvenContainer createMenu(int id, PlayerInventory playerInv) {
        return new SnowcapOvenContainer(id, playerInv, (IInventory)this, this.field_214013_b);
    }

    public void func_73660_a() {
        boolean isBurning = this.isBurning();
        boolean shouldUpdate = false;
        if (this.isBurning()) {
            this.setBurnTime(this.getBurnTime() - 1);
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelStack = (ItemStack)this.field_214012_a.get(1);
            if (this.isBurning() || !fuelStack.func_190926_b() && !((ItemStack)this.field_214012_a.get(0)).func_190926_b()) {
                IRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(this.field_214014_c, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.func_214008_b(recipe)) {
                    this.setBurnTime(this.func_213997_a(fuelStack));
                    this.setRecipesUsed(this.getBurnTime());
                    if (this.isBurning()) {
                        shouldUpdate = true;
                        if (fuelStack.hasContainerItem()) {
                            this.freezeFuel(fuelStack);
                            this.field_214012_a.set(1, (Object)fuelStack.getContainerItem());
                        } else if (!fuelStack.func_190926_b()) {
                            this.freezeFuel(fuelStack);
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190926_b()) {
                                this.field_214012_a.set(1, (Object)fuelStack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.func_214008_b(recipe)) {
                    this.setCookTimeVar(this.getCookTimeVar() + 1);
                    if (this.getCookTimeVar() == this.getCookTimeTotal()) {
                        this.setCookTimeVar(0);
                        this.setCookTimeTotal(this.func_214005_h());
                        this.smelt(recipe);
                        shouldUpdate = true;
                    }
                } else {
                    this.setCookTimeVar(0);
                }
            } else if (!this.isBurning() && this.getCookTimeVar() > 0) {
                this.setCookTimeVar(MathHelper.func_76125_a((int)(this.getCookTimeVar() - 2), (int)0, (int)this.getCookTimeTotal()));
            }
            if (isBurning != this.isBurning()) {
                shouldUpdate = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (shouldUpdate) {
            this.func_70296_d();
        }
    }

    protected int func_213997_a(ItemStack fuel) {
        if (SnowcapOvenTileEntity.isFuel(fuel)) {
            int value = ((FreezingRecipe)BlueSkiesData.SNOWCAP_OVEN_FREEZING.getValue(fuel.func_77973_b())).fuelAmount;
            int damage = fuel.func_77952_i();
            if (damage > 0) {
                int maxDamage = fuel.func_77958_k();
                int scaledValue = (int)((double)(maxDamage - damage) / (double)maxDamage * (double)value);
                return LogicUtil.bind(0, scaledValue, value);
            }
            return value;
        }
        return 0;
    }

    private void freezeFuel(ItemStack fuelStack) {
        if (fuelStack != null && !fuelStack.func_190926_b() && SnowcapOvenTileEntity.isFuel(fuelStack)) {
            FreezingRecipe recipe = (FreezingRecipe)BlueSkiesData.SNOWCAP_OVEN_FREEZING.getValue(fuelStack.func_77973_b());
            ItemStack freezingOutput = recipe.getOutput();
            ItemStack frozenStack = (ItemStack)this.field_214012_a.get(3);
            if (frozenStack.func_190926_b()) {
                int damage = fuelStack.func_77952_i();
                int outputMaxDamage = freezingOutput.func_77958_k();
                if (damage > 0 && outputMaxDamage > 0) {
                    int maxDamage = fuelStack.func_77958_k();
                    int scaledOutputDamage = (int)((double)damage / (double)maxDamage * (double)outputMaxDamage);
                    freezingOutput.func_196085_b(LogicUtil.bind(0, scaledOutputDamage, outputMaxDamage));
                }
                this.field_214012_a.set(3, (Object)freezingOutput.func_77946_l());
            } else if (frozenStack.func_77973_b() == freezingOutput.func_77973_b() && frozenStack.func_190916_E() < frozenStack.func_77976_d()) {
                frozenStack.func_190917_f(freezingOutput.func_190916_E());
                if (frozenStack.func_190916_E() > frozenStack.func_77976_d()) {
                    frozenStack.func_190920_e(frozenStack.func_77976_d());
                }
            }
        }
    }

    private boolean isBurning() {
        return this.getBurnTime() > 0;
    }

    private void smelt(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.func_214008_b(recipe)) {
            ItemStack rawStack = (ItemStack)this.field_214012_a.get(0);
            ItemStack recipeOutput = recipe.func_77571_b();
            ItemStack outputStack = (ItemStack)this.field_214012_a.get(2);
            if (outputStack.func_190926_b()) {
                this.field_214012_a.set(2, (Object)recipeOutput.func_77946_l());
            } else if (outputStack.func_77973_b() == recipeOutput.func_77973_b()) {
                outputStack.func_190917_f(recipeOutput.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (rawStack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.field_214012_a.get(1)).func_190926_b() && ((ItemStack)this.field_214012_a.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.field_214012_a.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            rawStack.func_190918_g(1);
        }
    }

    public int getBurnTime() {
        return this.field_214013_b.func_221476_a(0);
    }

    public int getRecipesUsed() {
        return this.field_214013_b.func_221476_a(1);
    }

    public int getCookTimeVar() {
        return this.field_214013_b.func_221476_a(2);
    }

    public int getCookTimeTotal() {
        return this.field_214013_b.func_221476_a(3);
    }

    public void setBurnTime(int value) {
        this.field_214013_b.func_221477_a(0, value);
    }

    public void setRecipesUsed(int value) {
        this.field_214013_b.func_221477_a(1, value);
    }

    public void setCookTimeVar(int value) {
        this.field_214013_b.func_221477_a(2, value);
    }

    public void setCookTimeTotal(int value) {
        this.field_214013_b.func_221477_a(3, value);
    }

    public static boolean isFuel(ItemStack stack) {
        return BlueSkiesData.SNOWCAP_OVEN_FREEZING.getData().containsKey(stack.func_77973_b());
    }

    public int[] func_180463_a(Direction side) {
        int[] nArray;
        if (side == Direction.DOWN) {
            return new int[]{2, 3, 1};
        }
        if (side == Direction.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2 || index == 3) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.field_214012_a.get(1);
        return SnowcapOvenTileEntity.isFuel(stack) || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1 || !SnowcapOvenTileEntity.isFuel(stack);
    }
}

