/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.tile_entity;

import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesTileEntityTypes;
import com.legacy.blue_skies.tile_entity.SkiesTileEntity;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class KeystoneTileEntity
extends SkiesTileEntity {
    public static BlockPos posUp = new BlockPos(0, 1, 0);
    protected EntityType<?> containedMob;
    protected Item key;
    protected Item arc;
    protected boolean spawnsBoss = true;
    protected boolean keysRequired = true;
    protected BlockPos spawnOffset;
    protected BlockPos teleportOffset;

    public KeystoneTileEntity(TileEntityType<?> tileEntityTypeIn, EntityType<?> containedMob, Item key, Item arc, BlockPos spawnOffset, BlockPos teleportOffset) {
        super(tileEntityTypeIn);
        this.containedMob = containedMob;
        this.key = key;
        this.arc = arc;
        this.spawnOffset = spawnOffset;
        this.teleportOffset = teleportOffset;
    }

    public void spawnMob(boolean spawnedFromArc) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.spawnsBoss && this.field_145850_b instanceof IServerWorld) {
            BlockPos position = this.field_174879_c.func_177971_a((Vector3i)this.spawnOffset);
            Entity mob = this.containedMob.func_200721_a(this.field_145850_b);
            if (mob instanceof ISkyBoss) {
                ((ISkyBoss)mob).setInvulTime(100);
                ((ISkyBoss)mob).setDungeonSpawned(true);
                ((ISkyBoss)mob).setHome(position);
                ((ISkyBoss)mob).setBossRespawned(spawnedFromArc);
                position = position.func_177971_a((Vector3i)((ISkyBoss)mob).bossSpawnOffset());
            }
            mob.func_70107_b((double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5);
            if (mob instanceof MobEntity) {
                ((MobEntity)mob).func_213386_a((IServerWorld)this.field_145850_b, this.field_145850_b.func_175649_E(position), SpawnReason.TRIGGERED, (ILivingEntityData)null, (CompoundNBT)null);
            }
            this.field_145850_b.func_217376_c(mob);
        }
    }

    public void teleportClosePlayers(World worldIn) {
        List players = worldIn.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c).func_186662_g(7.0));
        players.forEach(player -> this.teleportPlayer((PlayerEntity)player));
    }

    public void teleportPlayer(PlayerEntity player) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundCategory.BLOCKS, 0.5f, 1.0f);
            BlockPos position = this.field_174879_c.func_177971_a((Vector3i)this.teleportOffset);
            player.func_70634_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.containedMob = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(compound.func_74779_i("ContainedMob")));
        this.key = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("Key")));
        this.arc = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("Arc")));
        this.teleportOffset = compound.func_74764_b("TeleportOffset") ? NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("TeleportOffset")) : BlockPos.field_177992_a;
        this.spawnOffset = compound.func_74764_b("SpawnOffset") ? NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("SpawnOffset")) : BlockPos.field_177992_a;
        this.keysRequired = compound.func_74767_n("KeysRequired");
        this.spawnsBoss = compound.func_74767_n("SpawnsBoss");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("ContainedMob", this.containedMob.getRegistryName().toString());
        compound.func_74778_a("Arc", this.arc.getRegistryName().toString());
        compound.func_74778_a("Key", this.key.getRegistryName().toString());
        compound.func_218657_a("TeleportOffset", (INBT)NBTUtil.func_186859_a((BlockPos)this.teleportOffset));
        compound.func_218657_a("SpawnOffset", (INBT)NBTUtil.func_186859_a((BlockPos)this.spawnOffset));
        compound.func_74757_a("KeysRequired", this.keysRequired);
        compound.func_74757_a("SpawnsBoss", this.spawnsBoss);
        return compound;
    }

    public void setContainedMob(EntityType<?> containedMob) {
        this.containedMob = containedMob;
        this.func_70296_d();
    }

    public BlockPos getTeleportOffset() {
        return this.teleportOffset;
    }

    public void setTeleportOffset(BlockPos teleportOffset) {
        this.teleportOffset = teleportOffset;
        this.func_70296_d();
    }

    public BlockPos getSpawnOffset() {
        return this.spawnOffset;
    }

    public void setSpawnOffset(BlockPos spawnOffset) {
        this.spawnOffset = spawnOffset;
        this.func_70296_d();
    }

    public void setKey(Item key) {
        this.key = key;
        this.func_70296_d();
    }

    public void setArc(Item arc) {
        this.arc = arc;
        this.func_70296_d();
    }

    public boolean getSpawnsBoss() {
        return this.spawnsBoss;
    }

    public void setSpawnsBoss(boolean spawnsBoss) {
        this.spawnsBoss = spawnsBoss;
        this.func_70296_d();
    }

    public boolean getKeysRequired() {
        return this.keysRequired;
    }

    public void setKeysRequired(boolean keysRequired) {
        this.keysRequired = keysRequired;
        this.func_70296_d();
    }

    public boolean isCorrectArc(Item item) {
        return item == this.arc;
    }

    public boolean isCorrectKey(ItemStack stack) {
        return stack.func_77973_b() == this.key && stack.func_190916_E() >= 4;
    }

    public int getBossRoomSize() {
        return 15;
    }

    public int getBossRoomCeilingSize() {
        return 0;
    }

    public boolean isEverbrightBased() {
        return true;
    }

    public int getRequiredProgressionId() {
        return 0;
    }

    public static class PoisonKeystoneTileEntity
    extends KeystoneTileEntity {
        public PoisonKeystoneTileEntity() {
            super(SkiesTileEntityTypes.POISON_KEYSTONE, SkiesEntityTypes.ARACHNARCH, SkiesItems.poison_key, SkiesItems.poison_arc, posUp, posUp);
        }

        public void teleportPlayer(PlayerEntity player, Direction clickFace, Direction blockDirection) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                boolean leaving;
                boolean bl = leaving = clickFace != blockDirection;
                if (leaving && SkiesPlayerEvents.inBossFight(player)) {
                    this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_LOCKED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.leaving_in_fight"), true);
                    return;
                }
                this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundCategory.BLOCKS, 0.5f, 1.0f);
                BlockPos position = this.field_174879_c.func_177971_a((Vector3i)this.teleportOffset);
                if (leaving) {
                    position = this.field_174879_c.func_177971_a((Vector3i)new BlockPos(-this.teleportOffset.func_177958_n(), this.teleportOffset.func_177956_o(), -this.teleportOffset.func_177952_p()));
                }
                player.func_70634_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5);
            }
        }

        @Override
        public int getBossRoomCeilingSize() {
            return 15;
        }

        @Override
        public boolean isEverbrightBased() {
            return false;
        }

        @Override
        public int getRequiredProgressionId() {
            return 1;
        }
    }

    public static class NatureKeystoneTileEntity
    extends KeystoneTileEntity {
        public NatureKeystoneTileEntity() {
            super(SkiesTileEntityTypes.NATURE_KEYSTONE, SkiesEntityTypes.STARLIT_CRUSHER, SkiesItems.nature_key, SkiesItems.nature_arc, posUp, posUp);
        }

        public void teleportPlayer(PlayerEntity player, Direction clickFace, Direction blockDirection) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                boolean leaving;
                boolean bl = leaving = clickFace != blockDirection;
                if (leaving && SkiesPlayerEvents.inBossFight(player)) {
                    this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_LOCKED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.leaving_in_fight"), true);
                    return;
                }
                this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundCategory.BLOCKS, 0.5f, 1.0f);
                BlockPos position = this.field_174879_c.func_177971_a((Vector3i)this.teleportOffset);
                if (leaving) {
                    position = this.field_174879_c.func_177971_a((Vector3i)new BlockPos(-this.teleportOffset.func_177958_n(), this.teleportOffset.func_177956_o(), -this.teleportOffset.func_177952_p()));
                }
                player.func_70634_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5);
            }
        }

        @Override
        public int getRequiredProgressionId() {
            return 1;
        }
    }

    public static class DawnBlindingKeystoneTileEntity
    extends KeystoneTileEntity {
        public DawnBlindingKeystoneTileEntity() {
            super(SkiesTileEntityTypes.DAWN_BLINDING_KEYSTONE, SkiesEntityTypes.ALCHEMIST, SkiesItems.blinding_key, SkiesItems.dusk_arc, posUp, posUp);
        }

        @Override
        public int getBossRoomSize() {
            return 20;
        }

        @Override
        public boolean isEverbrightBased() {
            return false;
        }
    }

    public static class BrightBlindingKeystoneTileEntity
    extends KeystoneTileEntity {
        public BrightBlindingKeystoneTileEntity() {
            super(SkiesTileEntityTypes.BRIGHT_BLINDING_KEYSTONE, SkiesEntityTypes.SUMMONER, SkiesItems.blinding_key, SkiesItems.ethereal_arc, posUp, posUp);
        }

        @Override
        public int getBossRoomSize() {
            return 20;
        }
    }
}

