/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.tile_entity;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.container.HorizoniteForgeContainer;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.HorizoniteForgeFuel;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesTileEntityTypes;
import com.legacy.blue_skies.tile_entity.IRecipeUnlocker;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class HorizoniteForgeTileEntity
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity,
IRecipeUnlocker {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int energy;
    private int cookTime;
    private int maxCookTime;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    protected final IRecipeType<FurnaceRecipe> recipeType = IRecipeType.field_222150_b;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private final IIntArray data = new IIntArray(){

        public int func_221478_a() {
            return 4;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    HorizoniteForgeTileEntity.this.energy = value;
                    break;
                }
                case 1: {
                    BlueSkies.LOGGER.warn("Cannot set this value");
                    break;
                }
                case 2: {
                    HorizoniteForgeTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    HorizoniteForgeTileEntity.this.maxCookTime = value;
                }
            }
        }

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return HorizoniteForgeTileEntity.this.energy;
                }
                case 1: {
                    return HorizoniteForgeTileEntity.this.getMaxEnergy();
                }
                case 2: {
                    return HorizoniteForgeTileEntity.this.cookTime;
                }
                case 3: {
                    return HorizoniteForgeTileEntity.this.maxCookTime;
                }
            }
            IllegalArgumentException ex = new IllegalArgumentException("Value out of range");
            BlueSkies.LOGGER.fatal((Object)ex);
            throw ex;
        }
    };

    public HorizoniteForgeTileEntity() {
        super(SkiesTileEntityTypes.HORIZONITE_FORGE);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent(SkiesBlocks.horizonite_forge.func_149739_a());
    }

    protected HorizoniteForgeContainer createMenu(int id, PlayerInventory playerInv) {
        return new HorizoniteForgeContainer(id, playerInv, this, this.data);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.energy = nbt.func_74762_e("Energy");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.maxCookTime = nbt.func_74762_e("MaxCookTime");
        CompoundNBT recipesUsedNbt = nbt.func_74775_l("RecipesUsed");
        for (String s : recipesUsedNbt.func_150296_c()) {
            this.recipes.put((Object)new ResourceLocation(s), recipesUsedNbt.func_74762_e(s));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74768_a("CookTime", this.cookTime);
        nbt.func_74768_a("MaxCookTime", this.maxCookTime);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
        CompoundNBT recipesUsedNbt = new CompoundNBT();
        this.recipes.forEach((recipeId, craftedAmount) -> recipesUsedNbt.func_74768_a(recipeId.toString(), craftedAmount.intValue()));
        nbt.func_218657_a("RecipesUsed", (INBT)recipesUsedNbt);
        return nbt;
    }

    public void func_73660_a() {
        boolean isCooking = this.isCooking();
        boolean shouldUpdate = false;
        if (isCooking) {
            if (this.energy > 0) {
                --this.energy;
            }
        } else if (this.getRawStack().func_190926_b() && this.energy < this.getMaxEnergy()) {
            this.energy += 2;
        }
        if (this.energy > this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldBeLit;
            ItemStack fuelStack = this.getFuelStack();
            if (this.energy <= 0 && !this.getFuelStack().func_190926_b()) {
                this.energy += this.getEnergyFrom(fuelStack);
                fuelStack.func_190918_g(1);
            }
            FurnaceRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
            if (isCooking) {
                shouldUpdate = true;
                this.maxCookTime = this.getRecipeCookTime();
                if (this.canSmelt((IRecipe<?>)recipe)) {
                    ++this.cookTime;
                    if (this.cookTime >= this.maxCookTime) {
                        this.smelt((IRecipe<?>)recipe);
                        this.cookTime = 0;
                    }
                } else if (this.cookTime > 0) {
                    this.cookTime = 0;
                }
            } else if (this.canSmelt((IRecipe<?>)recipe)) {
                shouldUpdate = true;
                ++this.cookTime;
            }
            boolean bl = shouldBeLit = this.isCooking() || this.canSmelt((IRecipe<?>)recipe);
            if (isCooking != shouldBeLit) {
                shouldUpdate = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
            }
        }
        if (shouldUpdate) {
            this.func_70296_d();
        }
    }

    public boolean isCooking() {
        return this.cookTime > 0;
    }

    public ItemStack getRawStack() {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack getFuelStack() {
        return (ItemStack)this.items.get(1);
    }

    public ItemStack getOutputStack() {
        return (ItemStack)this.items.get(2);
    }

    public void setRawStack(ItemStack stack) {
        this.items.set(0, (Object)stack);
    }

    public void setFuelStack(ItemStack stack) {
        this.items.set(1, (Object)stack);
    }

    public void setOutputStack(ItemStack stack) {
        this.items.set(2, (Object)stack);
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMaxEnergy() {
        return 4800;
    }

    public int getEnergyFrom(ItemStack stack) {
        if (HorizoniteForgeTileEntity.isFuel(stack)) {
            return (int)((float)this.getMaxEnergy() * ((HorizoniteForgeFuel)BlueSkiesData.HORIZONITE_FORGE_FUEL.getValue(stack.func_77973_b())).fuelAmount);
        }
        return 0;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    private boolean canSmelt(@Nullable IRecipe<?> recipe) {
        if (!this.getRawStack().func_190926_b() && recipe != null && this.energy > 0) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput.func_190926_b()) {
                return false;
            }
            ItemStack outputSlotStack = (ItemStack)this.items.get(2);
            if (outputSlotStack.func_190926_b()) {
                return true;
            }
            if (!outputSlotStack.func_77969_a(recipeOutput)) {
                return false;
            }
            if (outputSlotStack.func_190916_E() + recipeOutput.func_190916_E() <= this.func_70297_j_() && outputSlotStack.func_190916_E() + recipeOutput.func_190916_E() <= outputSlotStack.func_77976_d()) {
                return true;
            }
            return outputSlotStack.func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d();
        }
        return false;
    }

    private void smelt(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack rawStack = this.getRawStack();
            ItemStack recipeOutput = recipe.func_77571_b();
            ItemStack outputStack = this.getOutputStack();
            if (outputStack.func_190926_b()) {
                this.setOutputStack(recipeOutput.func_77946_l());
            } else if (outputStack.func_77973_b() == recipeOutput.func_77973_b()) {
                outputStack.func_190917_f(recipeOutput.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            rawStack.func_190918_g(1);
        }
    }

    public int getRecipeCookTime() {
        return (int)((double)this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200).intValue() * 1.5);
    }

    public static boolean isFuel(ItemStack stack) {
        return BlueSkiesData.HORIZONITE_FORGE_FUEL.getData().containsKey(stack.func_77973_b());
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1 || !HorizoniteForgeTileEntity.isFuel(stack);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return true;
            }
            case 1: {
                return HorizoniteForgeTileEntity.isFuel(stack);
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeId = recipe.func_199560_c();
            this.recipes.addTo((Object)recipeId, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity player) {
    }

    @Override
    public void unlockRecipes(PlayerEntity player) {
        List<IRecipe<?>> list = this.grantStoredRecipeExperience(player.field_70170_p, player.func_213303_ch());
        player.func_195065_a(list);
        this.recipes.clear();
    }

    public List<IRecipe<?>> grantStoredRecipeExperience(World world, Vector3d pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            world.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                HorizoniteForgeTileEntity.splitAndSpawnExperience(world, pos, entry.getIntValue(), ((AbstractCookingRecipe)recipe).func_222138_b());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(World world, Vector3d pos, int craftedAmount, float experience) {
        int i = MathHelper.func_76141_d((float)((float)craftedAmount * experience));
        float f = MathHelper.func_226164_h_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack stack : this.items) {
            helper.func_194112_a(stack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

