/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.SkiesNoiseChunkGenerator;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeProvider;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.BunkerStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeProvider;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.util.BiomeIDs;
import com.legacy.structure_gel.access_helpers.DimensionAccessHelper;
import com.legacy.structure_gel.events.RegisterDimensionEvent;
import com.legacy.structure_gel.registrars.DimensionRegistrar;
import com.legacy.structure_gel.registrars.IRegistrar;
import com.legacy.structure_gel.util.DimensionTypeBuilder;
import com.legacy.structure_gel.util.RegistryHelper;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class SkiesDimensions {
    public static final ResourceLocation EVERBRIGHT_ID = BlueSkies.locate("everbright");
    public static final ResourceLocation EVERDAWN_ID = BlueSkies.locate("everdawn");
    public static final RegistryKey<World> EVERBRIGHT = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)EVERBRIGHT_ID);
    public static final RegistryKey<World> EVERDAWN = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)EVERDAWN_ID);
    private static final DimensionStructuresSettings BRIGHT_STRUCTURE_SETTINGS = new DimensionStructuresSettings(Optional.empty(), (Map)ImmutableMap.of((Object)SkiesStructures.BUNKER.getStructure(), (Object)((BunkerStructure)SkiesStructures.BUNKER.getStructure()).getSeparationSettings(), (Object)SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure(), (Object)((EverbrightBlindingDungeonStructure)SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()).getSeparationSettings(), (Object)SkiesStructures.NATURE_DUNGEON.getStructure(), (Object)((NatureDungeonStructure)SkiesStructures.NATURE_DUNGEON.getStructure()).getSeparationSettings()));
    private static final DimensionStructuresSettings DAWN_STRUCTURE_SETTINGS = new DimensionStructuresSettings(Optional.empty(), (Map)ImmutableMap.of((Object)SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure(), (Object)((EverdawnBlindingDungeonStructure)SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure()).getSeparationSettings(), (Object)SkiesStructures.POISON_DUNGEON.getStructure(), (Object)((PoisonDungeonStructure)SkiesStructures.POISON_DUNGEON.getStructure()).getSeparationSettings()));

    public static void init(RegisterDimensionEvent event) {
        BlueSkies.LOGGER.info("Registering Dimensions");
        BiomeIDs.reset();
        boolean largeBiomes = false;
        Function<RegistryKey, DimensionSettings> brightSettings = noiseSettings -> DimensionAccessHelper.newCustomSurfaceSettings((DimensionStructuresSettings)BRIGHT_STRUCTURE_SETTINGS, (boolean)false, (BlockState)SkiesBlocks.turquoise_stone.func_176223_P(), (BlockState)Blocks.field_150355_j.func_176223_P(), (ResourceLocation)noiseSettings.func_240901_a_());
        BiFunction<RegisterDimensionEvent, DimensionSettings, ChunkGenerator> brightGenerator = (e, s) -> {
            long seed = e.getSeed() + 80085L;
            return new SkiesNoiseChunkGenerator(new EverbrightBiomeProvider(seed, largeBiomes, (Registry<Biome>)e.getBiomeRegistry()), seed, () -> s);
        };
        Supplier<DimensionType> brightDimensionType = () -> DimensionTypeBuilder.of().fixedTime(OptionalLong.of(6000L)).effects(EVERBRIGHT_ID).build();
        RegistryHelper.handleRegistrar((IRegistrar)new DimensionRegistrar(event, EVERBRIGHT.func_240901_a_(), brightDimensionType, brightSettings, brightGenerator));
        Function<RegistryKey, DimensionSettings> dawnSettings = noiseSettings -> DimensionAccessHelper.newCustomSurfaceSettings((DimensionStructuresSettings)DAWN_STRUCTURE_SETTINGS, (boolean)false, (BlockState)SkiesBlocks.lunar_stone.func_176223_P(), (BlockState)Blocks.field_150355_j.func_176223_P(), (ResourceLocation)noiseSettings.func_240901_a_());
        BiFunction<RegisterDimensionEvent, DimensionSettings, ChunkGenerator> dawnGenerator = (e, s) -> {
            long seed = e.getSeed() + 1337L;
            return new SkiesNoiseChunkGenerator(new EverdawnBiomeProvider(seed, largeBiomes, (Registry<Biome>)e.getBiomeRegistry()), seed, () -> s);
        };
        Supplier<DimensionType> dawnDimensionType = () -> DimensionTypeBuilder.of().fixedTime(OptionalLong.of(23200L)).effects(EVERDAWN_ID).build();
        RegistryHelper.handleRegistrar((IRegistrar)new DimensionRegistrar(event, EVERDAWN.func_240901_a_(), dawnDimensionType, dawnSettings, dawnGenerator));
    }

    public static RegistryKey<World> everbrightKey() {
        return EVERBRIGHT;
    }

    public static RegistryKey<World> everdawnKey() {
        return EVERDAWN;
    }

    public static boolean inSkyDimension(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.field_70170_p.func_234923_W_() == SkiesDimensions.everbrightKey() || entity.field_70170_p.func_234923_W_() == SkiesDimensions.everdawnKey();
    }
}

