/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.client.gui.container.AlchemyTableContainer;
import com.legacy.blue_skies.client.gui.container.ArcsContainer;
import com.legacy.blue_skies.client.gui.container.BagOfSpoilsContainer;
import com.legacy.blue_skies.client.gui.container.FoodPrepContainer;
import com.legacy.blue_skies.client.gui.container.HorizoniteForgeContainer;
import com.legacy.blue_skies.client.gui.container.MountInventoryContainer;
import com.legacy.blue_skies.client.gui.container.SnowcapOvenContainer;
import com.legacy.blue_skies.client.gui.container.SummoningTableContainer;
import com.legacy.blue_skies.client.gui.container.ToolboxContainer;
import com.legacy.blue_skies.registries.SkiesRegistry;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesContainers {
    public static final ContainerType<ArcsContainer> ARC_INVENTORY = SkiesContainers.make((id, inv) -> new ArcsContainer(id, inv, inv.field_70458_d));
    public static final ContainerType<MountInventoryContainer> MOUNT_INVENTORY = SkiesContainers.makePacket((id, inv, buffer) -> new MountInventoryContainer(id, inv, buffer));
    public static final ContainerType<HorizoniteForgeContainer> HORIZONITE_FORGE = SkiesContainers.make(HorizoniteForgeContainer::new);
    public static final ContainerType<SnowcapOvenContainer> SNOWCAP_OVEN = SkiesContainers.make(SnowcapOvenContainer::new);
    public static final ContainerType<SummoningTableContainer> SUMMONING_TABLE = SkiesContainers.make(SummoningTableContainer::new);
    public static final ContainerType<AlchemyTableContainer> ALCHEMY_TABLE = SkiesContainers.make(AlchemyTableContainer::new);
    public static final ContainerType<ToolboxContainer> TOOLBOX = SkiesContainers.make(ToolboxContainer::new);
    public static final ContainerType<FoodPrepContainer> FOOD_PREP_TABLE = SkiesContainers.make(FoodPrepContainer::new);
    public static final ContainerType<BagOfSpoilsContainer> BAG_OF_SPOILS = SkiesContainers.make(BagOfSpoilsContainer::new);

    private static <T extends Container> ContainerType<T> makePacket(IContainerFactory<T> factory) {
        return new ContainerType(factory);
    }

    private static <T extends Container> ContainerType<T> make(ContainerType.IFactory<T> factory) {
        return new ContainerType(factory);
    }

    public static void init(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        SkiesRegistry.register(registry, "arc_inventory", ARC_INVENTORY);
        SkiesRegistry.register(registry, "mount_inventory", MOUNT_INVENTORY);
        SkiesRegistry.register(registry, "horizonite_forge", HORIZONITE_FORGE);
        SkiesRegistry.register(registry, "snowcap_oven", SNOWCAP_OVEN);
        SkiesRegistry.register(registry, "summoning_table", SUMMONING_TABLE);
        SkiesRegistry.register(registry, "alchemy_table", ALCHEMY_TABLE);
        SkiesRegistry.register(registry, "toolbox", TOOLBOX);
        SkiesRegistry.register(registry, "food_prep_table", FOOD_PREP_TABLE);
        SkiesRegistry.register(registry, "bag_of_spoils", BAG_OF_SPOILS);
    }
}

